/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class SynDefine extends Syntax {

	//
	private void defun(
			Datum bcar,
			Datum bcdr,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			Cons callsym,
			LispMessage mesg,
			List<Cons> symlist,
			boolean toplevel,
			CodeExecutor exec,
			IntStack memento) {
		// function definition
		Cons c = (Cons)bcar;

		// create a temporary Closure
		CompiledCode.Builder mbuild = new CompiledCode.Builder();
		Environment  menv = new Environment(env);

		// compile the list
		CompiledCode.Builder nbuild = new CompiledCode.Builder();
		Environment nenv = new Environment(menv);
		//symlist.add(callsym);
		SyntaxUtils.compileList(
				bcdr, nenv, comp, nbuild, c, true, mesg,
				new ArrayList<Cons>(), exec, memento);
		//symlist.remove(0);

		nbuild.addReturnOp();
		ClosureClass cln = new ClosureClass(
				c.getCdr(), nbuild.getCodeRef());

		mbuild.addPush(cln);
		mbuild.addReturnOp();

		// 一時的なClosureを生成する
		ClosureClass clm = new ClosureClass(
				Nil.NIL, mbuild.getCodeRef());

		// 一時的なClosureを呼び出す
		build.addPush(clm);
		build.addBeginList();
		build.addEndList();
		build.addCall();
		build.addBind(c.getCar());
		build.addPush(Undef.UNDEF);
	}

	//
	/*package*/ void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist,
			CodeExecutor exec,
			IntStack memento) {
		if(body instanceof Cons) {
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();

			if(bcar instanceof Cons) {
				Datum cz = ((Cons)bcar).getCar();
				if(!(cz instanceof SymbolName)) {
					throw mesg.getError("err.define.malform");
				}

				defun(bcar, bcdr, env, comp, build,
						callsym, mesg, symlist, toplevel,
						exec, memento);
			} else if(bcar instanceof SymbolName) {
				// constant definition
				SyntaxUtils.compileBind(
						bcar, bcdr, env, comp,
						build, callsym, toplevel,
						mesg, "err.define.malform",
						new ArrayList<Cons>(),
						exec, memento);
			} else {
				throw mesg.getError("err.define.malform");
			}
		} else {
			throw mesg.getError("err.define.malform");
		}
	}

}
