/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.parser;

import java.math.BigInteger;
import java.util.regex.Pattern;

/**
 * トークンの基底クラスです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public abstract class AwkToken {

	/**
	 * トークンの記述です。
	 */
	protected String desc;

	//
	AwkToken(String desc) {
		this.desc = desc;
	}

	/**
	 * 関係を取得します。
	 * 
	 * @return 関係
	 */
	public AwkRelop.Operator getRelation() {
		throw new RuntimeException();
	}

	/**
	 * 文字列定数またはシンボル名を取得します。
	 * 
	 * @return 文字列
	 */
	public String getString() {
		throw new RuntimeException();
	}

	/**
	 * 整数を取得します。
	 * 
	 * @return 整数
	 */
	public BigInteger getInteger() {
		throw new RuntimeException();
	}

	/**
	 * 浮動小数を取得します。
	 * 
	 * @return 浮動小数
	 */
	public double getFloat() {
		throw new RuntimeException();
	}

	/**
	 * 正規表現パターンを取得します。
	 * 
	 * @return パターン
	 */
	public Pattern getRegex() {
		throw new RuntimeException();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return desc;
	}

}
