/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.parser;

/**
 * 浮動小数定数のトークンです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03/09
 */
public class AwkFloatToken extends AwkToken {

	private double value;

	/**
	 * 浮動小数定数を生成します。
	 * 
	 * @param x 浮動小数をあらわす文字列
	 */
	public AwkFloatToken(String x) {
		super(x);
		value = Double.parseDouble(x);
	}

	/**
	 * 浮動小数定数を生成します。
	 * 
	 * @param x 値
	 */
	public AwkFloatToken(double x) {
		super(Double.toString(x));
		value = x;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.parser.AwkToken#getFloat()
	 */
	public double getFloat() {
		return value;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return (int)Double.doubleToRawLongBits(value);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if(o instanceof AwkFloatToken) {
			return value == ((AwkFloatToken)o).value;
		}
		return false;
	}

}
