/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/25
 */
public class DefaultShVirtualDirectory extends AbstractShVirtualDirectory {

	/**
	 * @param parentFile
	 * @param currentName
	 */
	public DefaultShVirtualDirectory(ShFile parentFile,
			String currentName) {
		super(parentFile, currentName);
	}

	private Map<String, ShFile> files = new TreeMap<String, ShFile>();

	/**
	 * 
	 * @param file
	 */
	public void addFile(ShFile file) {
		files.put(file.getName(), file);
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public ShFile getFile(String name) {
		return files.get(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFile#getFiles()
	 */
	public Collection<ShFile> getFiles() {
		return files.values();
	}

}
