/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fa;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.fa.PersianCharFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    public static final String STOPWORDS_COMMENT = "#";

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public PersianAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public PersianAnalyzer(Version matchVersion, Set<?> stopwords) {
        super(matchVersion, stopwords);
    }

    @Deprecated
    public PersianAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])stopwords));
    }

    @Deprecated
    public PersianAnalyzer(Version matchVersion, Hashtable<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    @Deprecated
    public PersianAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, (Set<?>)WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader((File)stopwords, (Charset)IOUtils.CHARSET_UTF_8), (String)STOPWORDS_COMMENT, (Version)matchVersion));
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        Object source = this.matchVersion.onOrAfter(Version.LUCENE_31) ? new StandardTokenizer(this.matchVersion, reader) : new ArabicLetterTokenizer(this.matchVersion, reader);
        Object result = new LowerCaseFilter(this.matchVersion, (TokenStream)source);
        result = new ArabicNormalizationFilter((TokenStream)result);
        result = new PersianNormalizationFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)new StopFilter(this.matchVersion, (TokenStream)result, (Set)this.stopwords));
    }

    protected Reader initReader(Reader reader) {
        return this.matchVersion.onOrAfter(Version.LUCENE_31) ? new PersianCharFilter(CharReader.get((Reader)reader)) : reader;
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = PersianAnalyzer.loadStopwordSet((boolean)false, (Class)PersianAnalyzer.class, (String)PersianAnalyzer.DEFAULT_STOPWORD_FILE, (String)PersianAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

