/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.apache.pdfbox.util.PDFCloneUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMergerUtility {
    private List<InputStream> sources = new ArrayList<InputStream>();
    private String destinationFileName;
    private OutputStream destinationStream;
    private boolean ignoreAcroFormErrors = false;
    private int nextFieldNum = 1;

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destination) {
        this.destinationFileName = destination;
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    public void setDestinationStream(OutputStream destinationStream) {
        this.destinationStream = destinationStream;
    }

    public void addSource(String source) {
        try {
            this.sources.add(new FileInputStream(new File(source)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(File source) {
        try {
            this.sources.add(new FileInputStream(source));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(InputStream source) {
        this.sources.add(source);
    }

    public void addSources(List<InputStream> sources) {
        this.sources.addAll(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDocuments() throws IOException, COSVisitorException {
        PDDocument destination = null;
        if (this.sources != null && this.sources.size() > 0) {
            Vector<PDDocument> tobeclosed = new Vector<PDDocument>();
            try {
                Iterator<InputStream> sit = this.sources.iterator();
                InputStream sourceFile = sit.next();
                destination = PDDocument.load(sourceFile);
                while (sit.hasNext()) {
                    sourceFile = sit.next();
                    PDDocument source = PDDocument.load(sourceFile);
                    tobeclosed.add(source);
                    this.appendDocument(destination, source);
                }
                if (this.destinationStream == null) {
                    destination.save(this.destinationFileName);
                } else {
                    destination.save(this.destinationStream);
                }
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
                for (PDDocument doc : tobeclosed) {
                    doc.close();
                }
            }
        }
    }

    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        PDFCloneUtility cloner;
        PDDocumentCatalog srcCatalog;
        PDDocumentCatalog destCatalog;
        block25: {
            if (destination.isEncrypted()) {
                throw new IOException("Error: destination PDF is encrypted, can't append encrypted PDF documents.");
            }
            if (source.isEncrypted()) {
                throw new IOException("Error: source PDF is encrypted, can't append encrypted PDF documents.");
            }
            PDDocumentInformation destInfo = destination.getDocumentInformation();
            PDDocumentInformation srcInfo = source.getDocumentInformation();
            destInfo.getDictionary().mergeInto(srcInfo.getDictionary());
            destCatalog = destination.getDocumentCatalog();
            srcCatalog = source.getDocumentCatalog();
            if (destCatalog.getOpenAction() == null) {
                destCatalog.setOpenAction(srcCatalog.getOpenAction());
            }
            cloner = new PDFCloneUtility(destination);
            try {
                PDAcroForm destAcroForm = destCatalog.getAcroForm();
                PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
                if (destAcroForm == null) {
                    cloner.cloneForNewDocument(srcAcroForm);
                    destCatalog.setAcroForm(srcAcroForm);
                } else if (srcAcroForm != null) {
                    this.mergeAcroForm(cloner, destAcroForm, srcAcroForm);
                }
            }
            catch (Exception e) {
                if (this.ignoreAcroFormErrors) break block25;
                throw (IOException)e;
            }
        }
        COSArray destThreads = (COSArray)destCatalog.getCOSDictionary().getDictionaryObject(COSName.THREADS);
        COSArray srcThreads = (COSArray)cloner.cloneForNewDocument(destCatalog.getCOSDictionary().getDictionaryObject(COSName.THREADS));
        if (destThreads == null) {
            destCatalog.getCOSDictionary().setItem(COSName.THREADS, (COSBase)srcThreads);
        } else {
            destThreads.addAll(srcThreads);
        }
        PDDocumentNameDictionary destNames = destCatalog.getNames();
        PDDocumentNameDictionary srcNames = srcCatalog.getNames();
        if (srcNames != null) {
            if (destNames == null) {
                destCatalog.getCOSDictionary().setItem(COSName.NAMES, cloner.cloneForNewDocument(srcNames));
            } else {
                cloner.cloneMerge(srcNames, destNames);
            }
        }
        PDDocumentOutline destOutline = destCatalog.getDocumentOutline();
        PDDocumentOutline srcOutline = srcCatalog.getDocumentOutline();
        if (srcOutline != null) {
            if (destOutline == null) {
                PDDocumentOutline cloned = new PDDocumentOutline((COSDictionary)cloner.cloneForNewDocument(srcOutline));
                destCatalog.setDocumentOutline(cloned);
            } else {
                PDOutlineItem first = srcOutline.getFirstChild();
                if (first != null) {
                    PDOutlineItem clonedFirst = new PDOutlineItem((COSDictionary)cloner.cloneForNewDocument(first));
                    destOutline.appendChild(clonedFirst);
                }
            }
        }
        String destPageMode = destCatalog.getPageMode();
        String srcPageMode = srcCatalog.getPageMode();
        if (destPageMode == null) {
            destCatalog.setPageMode(srcPageMode);
        }
        COSDictionary destLabels = (COSDictionary)destCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGE_LABELS);
        COSDictionary srcLabels = (COSDictionary)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGE_LABELS);
        if (srcLabels != null) {
            int destPageCount = destination.getNumberOfPages();
            COSArray destNums = null;
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.NUMS, (COSBase)destNums);
                destCatalog.getCOSDictionary().setItem(COSName.PAGE_LABELS, (COSBase)destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.NUMS);
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.NUMS);
            if (srcNums != null) {
                for (int i = 0; i < srcNums.size(); i += 2) {
                    COSNumber labelIndex = (COSNumber)srcNums.getObject(i);
                    long labelIndexValue = labelIndex.intValue();
                    destNums.add(COSInteger.get(labelIndexValue + (long)destPageCount));
                    destNums.add(cloner.cloneForNewDocument(srcNums.getObject(i + 1)));
                }
            }
        }
        COSStream destMetadata = (COSStream)destCatalog.getCOSDictionary().getDictionaryObject(COSName.METADATA);
        COSStream srcMetadata = (COSStream)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.METADATA);
        if (destMetadata == null && srcMetadata != null) {
            PDStream newStream = new PDStream(destination, srcMetadata.getUnfilteredStream(), false);
            newStream.getStream().mergeInto(srcMetadata);
            newStream.addCompression();
            destCatalog.getCOSDictionary().setItem(COSName.METADATA, (COSObjectable)newStream);
        }
        List pages = source.getDocumentCatalog().getAllPages();
        for (PDPage page : pages) {
            PDPage newPage = new PDPage((COSDictionary)cloner.cloneForNewDocument(page.getCOSDictionary()));
            newPage.setCropBox(page.findCropBox());
            newPage.setMediaBox(page.findMediaBox());
            newPage.setRotation(page.findRotation());
            destination.addPage(newPage);
        }
    }

    private void mergeAcroForm(PDFCloneUtility cloner, PDAcroForm destAcroForm, PDAcroForm srcAcroForm) throws IOException {
        List destFields = destAcroForm.getFields();
        List srcFields = srcAcroForm.getFields();
        if (srcFields != null) {
            if (destFields == null) {
                destFields = new COSArrayList();
                destAcroForm.setFields(destFields);
            }
            for (PDField srcField : srcFields) {
                PDField destField = PDFieldFactory.createField(destAcroForm, (COSDictionary)cloner.cloneForNewDocument(srcField.getDictionary()));
                if (destAcroForm.getField(destField.getFullyQualifiedName()) != null) {
                    destField.setPartialName("dummyFieldName" + this.nextFieldNum++);
                }
                destFields.add(destField);
            }
        }
    }

    public boolean isIgnoreAcroFormErrors() {
        return this.ignoreAcroFormErrors;
    }

    public void setIgnoreAcroFormErrors(boolean ignoreAcroFormErrors) {
        this.ignoreAcroFormErrors = ignoreAcroFormErrors;
    }
}

