/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.xml.EnmlException;
import cx.fbn.nevernote.xml.XMLNoteRepairHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLNoteRepair {
    public boolean saveInvalidXML;

    public String parse(String xmlData, boolean validate) {
        this.saveInvalidXML = false;
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xmlData));
        XMLNoteRepairHandler handler = new XMLNoteRepairHandler();
        File dtdFile = Global.getFileManager().getXMLDirFile("enml2.dtd");
        String dtd = dtdFile.toURI().toString();
        xmlData = xmlData.replace("<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml2.dtd'>", "<!DOCTYPE en-note SYSTEM \"" + dtd + "\">");
        xmlData = xmlData.replace("<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">", "<!DOCTYPE en-note SYSTEM \"" + dtd + "\">");
        handler.setXml(xmlData);
        is.setCharacterStream(new StringReader(handler.getXml()));
        boolean fixed = false;
        int i = 0;
        int max = 10;
        if (validate) {
            max = 10000;
        }
        while (!fixed && i < max) {
            try {
                ++i;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(validate);
                SAXParser parser = factory.newSAXParser();
                parser.parse(is, (DefaultHandler)handler);
                fixed = true;
            }
            catch (EnmlException e) {
                String element;
                String message = e.getMessage();
                this.saveInvalidXML = true;
                boolean found = false;
                int endAttribute = message.indexOf(" must be declared for element type ");
                if (message.startsWith("Attribute ") && endAttribute > -1) {
                    String attribute = message.substring(11, endAttribute - 1);
                    element = message.substring(message.indexOf("\"", endAttribute + 3));
                    element = element.replace("\"", "");
                    element = element.substring(0, element.length() - 1);
                    Global.addInvalidAttribute(element, attribute);
                    handler.stripAttribute(attribute, e.getLineNumber(), e.getColumnNumber());
                    is.setCharacterStream(new StringReader(handler.getXml()));
                    found = true;
                }
                int endElement = message.indexOf(" must be declared.");
                if (message.startsWith("Element type") && endElement > -1) {
                    element = message.substring(14, endElement - 1);
                    Global.addInvalidElement(element);
                    handler.renameElement(element, e.getLineNumber(), e.getColumnNumber());
                    is.setCharacterStream(new StringReader(handler.getXml()));
                    found = true;
                }
                if (found) continue;
                System.err.println("New enml validation error: " + e.getMessage() + " Line:" + e.getLineNumber() + " Column:" + e.getColumnNumber());
            }
            catch (SAXParseException e) {
                System.err.println("SAXParse Exception - Attempt #" + i + " " + e.getMessage());
                handler.repair(e.getLineNumber(), e.getColumnNumber());
                is.setCharacterStream(new StringReader(handler.getXml()));
                if (!validate) continue;
                System.err.println("Error validating ENML2 DTD");
                return null;
            }
            catch (SAXException e) {
                System.err.append("SAXException");
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                System.err.println("Parser Config Error");
                e.printStackTrace();
            }
            catch (IOException e) {
                System.err.println("IO Exception");
                e.printStackTrace();
            }
        }
        if (!fixed) {
            return null;
        }
        xmlData = handler.getXml();
        xmlData = xmlData.replace("<!DOCTYPE en-note SYSTEM \"" + dtd + "\">", "<!DOCTYPE en-note SYSTEM 'http://xml.evernote.com/pub/enml2.dtd'>");
        return xmlData;
    }
}

