/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import com.evernote.edam.type.Tag;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QMimeData;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QDragEnterEvent;
import com.trolltech.qt.gui.QDragMoveEvent;
import com.trolltech.qt.gui.QHeaderView;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QTreeWidget;
import com.trolltech.qt.gui.QTreeWidgetItem;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.filters.TagCounter;
import cx.fbn.nevernote.gui.NTreeWidgetItem;
import cx.fbn.nevernote.signals.NoteSignal;
import cx.fbn.nevernote.signals.TagSignal;
import cx.fbn.nevernote.sql.DatabaseConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TagTreeWidget
extends QTreeWidget {
    private QAction editAction;
    private QAction deleteAction;
    private QAction addAction;
    private QAction iconAction;
    private QAction mergeAction;
    public TagSignal tagSignal;
    public NoteSignal noteSignal;
    private boolean showAllTags;
    private final DatabaseConnection db;
    private HashMap<String, QIcon> icons;
    public QSignalEmitter.Signal0 selectionSignal;
    public String selectedTag;
    private boolean rightButtonClicked;
    private List<TagCounter> lastCount;

    public TagTreeWidget(DatabaseConnection d) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(this.tr("Tags"));
        headers.add("");
        this.showAllTags = true;
        this.setAcceptDrops(true);
        this.setDragEnabled(true);
        this.setColumnCount(2);
        this.header().setResizeMode(0, QHeaderView.ResizeMode.ResizeToContents);
        this.header().setResizeMode(1, QHeaderView.ResizeMode.Stretch);
        this.header().setMovable(false);
        this.header().setStyleSheet("QHeaderView::section {border: 0.0em;}");
        this.db = d;
        this.selectionSignal = new QSignalEmitter.Signal0((QSignalEmitter)this);
        this.tagSignal = new TagSignal();
        this.noteSignal = new NoteSignal();
        this.setDragDropMode(QAbstractItemView.DragDropMode.DragDrop);
        this.setHeaderLabels(headers);
        this.setSelectionMode(QAbstractItemView.SelectionMode.ExtendedSelection);
        this.selectedTag = "";
        this.itemClicked.connect((Object)this, "itemClicked()");
        int width = Global.getColumnWidth("tagTreeName");
        if (width > 0) {
            this.setColumnWidth(0, width);
        }
    }

    public void setEditAction(QAction e) {
        this.editAction = e;
    }

    public void setDeleteAction(QAction d) {
        this.deleteAction = d;
    }

    public void setAddAction(QAction a) {
        this.addAction = a;
    }

    public void setIconAction(QAction i) {
        this.iconAction = i;
    }

    public void setMergeAction(QAction i) {
        this.mergeAction = i;
    }

    public void insertTag(String name, String guid) {
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QIcon icon = new QIcon(String.valueOf(iconPath) + "tag.png");
        Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        NTreeWidgetItem child = new NTreeWidgetItem();
        child.setText(0, name);
        child.setIcon(0, icon);
        child.setText(2, guid);
        child.setTextAlignment(1, ra.value());
        this.addTopLevelItem(child);
        this.resizeColumnToContents(0);
        this.resizeColumnToContents(1);
        this.sortItems(0, Qt.SortOrder.AscendingOrder);
    }

    private QIcon findDefaultIcon(String guid) {
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QIcon icon = new QIcon(String.valueOf(iconPath) + "tag.png");
        QIcon linkedIcon = new QIcon(String.valueOf(iconPath) + "tag-orange.png");
        if (this.db.getTagTable().getNotebookGuid(guid) == null || this.db.getTagTable().getNotebookGuid(guid).equals("")) {
            return icon;
        }
        return linkedIcon;
    }

    List<String> findExpandedTags(QTreeWidgetItem item) {
        ArrayList<String> list = new ArrayList<String>();
        if (item.isExpanded()) {
            list.add(item.text(0));
        }
        int i = 0;
        while (i < item.childCount()) {
            List<String> childrenList = this.findExpandedTags(item.child(i));
            int j = 0;
            while (j < childrenList.size()) {
                list.add(childrenList.get(j));
                ++j;
            }
            ++i;
        }
        return list;
    }

    void expandTags(QTreeWidgetItem item, List<String> expandedTags) {
        int i = 0;
        while (i < item.childCount()) {
            this.expandTags(item.child(i), expandedTags);
            ++i;
        }
        i = 0;
        while (i < expandedTags.size()) {
            if (expandedTags.get(i).equalsIgnoreCase(item.text(0))) {
                this.expandItem(item);
                i = expandedTags.size();
            }
            ++i;
        }
    }

    public void load(List<Tag> tags) {
        ArrayList<NTreeWidgetItem> index = new ArrayList<NTreeWidgetItem>();
        QTreeWidgetItem root = this.invisibleRootItem();
        List<String> expandedTags = this.findExpandedTags(root);
        this.clear();
        String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
        QIcon icon = new QIcon(String.valueOf(iconPath) + "tag.png");
        Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        ArrayList<Tag> tempList = new ArrayList<Tag>();
        int i = 0;
        while (i < tags.size()) {
            tempList.add(tags.get(i));
            ++i;
        }
        while (tempList.size() > 0) {
            i = 0;
            while (i < tempList.size()) {
                NTreeWidgetItem child;
                Tag tag = (Tag)tempList.get(i);
                if (tag.getParentGuid() == null || tag.getParentGuid().equals("")) {
                    child = new NTreeWidgetItem();
                    child.setText(0, tag.getName());
                    if (this.icons != null && !this.icons.containsKey(tag.getGuid())) {
                        child.setIcon(0, this.findDefaultIcon(tag.getGuid()));
                    } else {
                        child.setIcon(0, this.icons.get(tag.getGuid()));
                    }
                    child.setText(2, tag.getGuid());
                    child.setTextAlignment(1, ra.value());
                    index.add(child);
                    this.addTopLevelItem(child);
                    tempList.remove(i);
                } else {
                    int j = 0;
                    while (j < index.size()) {
                        if (((NTreeWidgetItem)((Object)index.get(j))).text(2).equals(tag.getParentGuid())) {
                            child = new NTreeWidgetItem();
                            child.setText(0, tag.getName());
                            child.setIcon(0, icon);
                            child.setText(2, tag.getGuid());
                            child.setTextAlignment(1, ra.value());
                            if (this.icons != null && !this.icons.containsKey(tag.getGuid())) {
                                child.setIcon(0, this.findDefaultIcon(tag.getGuid()));
                            } else {
                                child.setIcon(0, this.icons.get(tag.getGuid()));
                            }
                            tempList.remove(i);
                            index.add(child);
                            ((NTreeWidgetItem)((Object)index.get(j))).addChild(child);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.resizeColumnToContents(0);
        this.resizeColumnToContents(1);
        this.sortItems(0, Qt.SortOrder.AscendingOrder);
        this.expandTags(this.invisibleRootItem(), expandedTags);
        if (this.lastCount != null) {
            this.updateCounts(this.lastCount);
        }
    }

    public void showAllTags(boolean value) {
        this.showAllTags = value;
    }

    public void updateCounts(List<TagCounter> counts) {
        this.lastCount = counts;
        Qt.MatchFlags flags = new Qt.MatchFlags(new Qt.MatchFlag[0]);
        flags.set((QtEnumerator[])new Qt.MatchFlag[]{Qt.MatchFlag.MatchWildcard});
        flags.set((QtEnumerator[])new Qt.MatchFlag[]{Qt.MatchFlag.MatchRecursive});
        List children = this.findItems("*", flags);
        QBrush black = new QBrush();
        black.setColor(QColor.black);
        QBrush blue = new QBrush();
        blue.setColor(QColor.blue);
        if (!Global.tagBehavior().equalsIgnoreCase("ColorActive")) {
            blue.setColor(QColor.black);
        }
        int i = 0;
        while (i < children.size()) {
            ((QTreeWidgetItem)children.get(i)).setText(1, "0");
            ((QTreeWidgetItem)children.get(i)).setForeground(0, black);
            ((QTreeWidgetItem)children.get(i)).setForeground(1, black);
            if (!this.showAllTags && (Global.tagBehavior().equalsIgnoreCase("HideInactiveCount") || Global.tagBehavior().equalsIgnoreCase("NoHideInactiveCount"))) {
                ((QTreeWidgetItem)children.get(i)).setHidden(true);
            } else {
                ((QTreeWidgetItem)children.get(i)).setHidden(false);
            }
            if (((QTreeWidgetItem)children.get(i)).isSelected()) {
                ((QTreeWidgetItem)children.get(i)).setHidden(false);
            }
            ++i;
        }
        i = 0;
        while (i < counts.size()) {
            int j = 0;
            while (j < children.size()) {
                String guid = ((QTreeWidgetItem)children.get(j)).text(2);
                if (counts.get(i).getGuid().equals(guid)) {
                    ((QTreeWidgetItem)children.get(j)).setText(1, new Integer(counts.get(i).getCount()).toString());
                    if (counts.get(i).getCount() > 0 || ((QTreeWidgetItem)children.get(j)).isSelected()) {
                        ((QTreeWidgetItem)children.get(j)).setForeground(0, blue);
                        ((QTreeWidgetItem)children.get(j)).setForeground(1, blue);
                        QTreeWidgetItem parent = (QTreeWidgetItem)children.get(j);
                        while (parent != null) {
                            parent.setForeground(0, blue);
                            parent.setForeground(1, blue);
                            parent.setHidden(false);
                            parent = parent.parent();
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean selectGuid(String guid) {
        Qt.MatchFlags flags = new Qt.MatchFlags(new Qt.MatchFlag[0]);
        flags.set((QtEnumerator[])new Qt.MatchFlag[]{Qt.MatchFlag.MatchWildcard});
        flags.set((QtEnumerator[])new Qt.MatchFlag[]{Qt.MatchFlag.MatchRecursive});
        List children = this.findItems("*", flags);
        int i = 0;
        while (i < children.size()) {
            if (((QTreeWidgetItem)children.get(i)).text(2).equals(guid)) {
                ((QTreeWidgetItem)children.get(i)).setSelected(true);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void dragMoveEvent(QDragMoveEvent event) {
        if (event.mimeData().hasFormat("application/x-nevernote-note")) {
            if (event.answerRect().intersects(this.childrenRect())) {
                event.acceptProposedAction();
            }
            return;
        }
    }

    public void dragEnterEvent(QDragEnterEvent event) {
        if (event.mimeData().hasFormat("application/x-nevernote-note")) {
            event.accept();
            return;
        }
        if (event.source() == this) {
            if (Global.tagBehavior().equals("HideInactiveCount")) {
                event.ignore();
                return;
            }
            event.mimeData().setData("application/x-nevernote-tag", new QByteArray(this.currentItem().text(2)));
            event.accept();
            return;
        }
        event.ignore();
    }

    public boolean dropMimeData(QTreeWidgetItem parent, int index, QMimeData data, Qt.DropAction action) {
        if (data.hasFormat("application/x-nevernote-tag")) {
            QTreeWidgetItem newChild;
            QByteArray d = data.data("application/x-nevernote-tag");
            String current = d.toString();
            if (!this.checkParent(parent, current)) {
                return false;
            }
            if (parent == null) {
                this.db.getTagTable().updateTagParent(current, "");
                newChild = new QTreeWidgetItem((QTreeWidget)this);
            } else {
                this.db.getTagTable().updateTagParent(current, parent.text(2));
                newChild = new QTreeWidgetItem(parent);
            }
            this.copyTreeItem(this.currentItem(), newChild);
            this.currentItem().setHidden(true);
            this.sortItems(0, Qt.SortOrder.AscendingOrder);
            return true;
        }
        if (data.hasFormat("application/x-nevernote-note")) {
            String[] noteGuidArray;
            String notebookGuid = this.db.getTagTable().getNotebookGuid(parent.text(2));
            QByteArray d = data.data("application/x-nevernote-note");
            String s = d.toString();
            String[] stringArray = noteGuidArray = s.split(" ");
            int n = noteGuidArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Note n3 = this.db.getNoteTable().getNote(element.trim(), false, false, false, false, false);
                if (!this.db.getNoteTable().noteTagsTable.checkNoteNoteTags(element.trim(), parent.text(2)) && (notebookGuid == null || n3.getNotebookGuid().equalsIgnoreCase(notebookGuid) || notebookGuid.equals("")) && !this.db.getNotebookTable().isReadOnly(n3.getNotebookGuid())) {
                    this.db.getNoteTable().noteTagsTable.saveNoteTag(element.trim(), parent.text(2), true);
                    this.noteSignal.tagsAdded.emit((Object)element.trim(), (Object)parent.text(2));
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void contextMenuEvent(QContextMenuEvent event) {
        QMenu menu = new QMenu((QWidget)this);
        menu.addAction(this.addAction);
        menu.addAction(this.editAction);
        menu.addAction(this.deleteAction);
        menu.addAction(this.mergeAction);
        menu.addSeparator();
        menu.addAction(this.iconAction);
        menu.exec(event.globalPos());
    }

    public void setIcons(HashMap<String, QIcon> i) {
        this.icons = i;
    }

    private void copyTreeItem(QTreeWidgetItem source, QTreeWidgetItem target) {
        target.setText(0, source.text(0));
        target.setIcon(0, source.icon(0));
        target.setText(1, source.text(1));
        target.setText(2, source.text(2));
        Qt.Alignment ra = new Qt.Alignment(new Qt.AlignmentFlag[]{Qt.AlignmentFlag.AlignRight});
        target.setTextAlignment(1, ra.value());
        int i = 0;
        while (i < source.childCount()) {
            QTreeWidgetItem newChild = new QTreeWidgetItem(target);
            this.copyTreeItem(source.child(i), newChild);
            source.child(i).setHidden(true);
            ++i;
        }
    }

    private boolean checkParent(QTreeWidgetItem parent, String child) {
        if (parent != null && parent.text(2).equals(child)) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        return this.checkParent(parent.parent(), child);
    }

    public void selectTag(QTreeWidgetItem item) {
        Qt.MatchFlags flags = new Qt.MatchFlags(new Qt.MatchFlag[0]);
        flags.set((QtEnumerator[])new Qt.MatchFlag[]{Qt.MatchFlag.MatchWildcard});
        flags.set((QtEnumerator[])new Qt.MatchFlag[]{Qt.MatchFlag.MatchRecursive});
        List children = this.findItems("*", flags);
        int j = 0;
        while (j < children.size()) {
            String guid = ((QTreeWidgetItem)children.get(j)).text(2);
            if (item.text(2).equals(guid)) {
                ((QTreeWidgetItem)children.get(j)).setSelected(true);
            }
            ++j;
        }
    }

    private void itemClicked() {
        List selectedItem = this.selectedItems();
        if (selectedItem.size() == 1) {
            if (((QTreeWidgetItem)selectedItem.get(0)).text(0).equalsIgnoreCase(this.selectedTag) && !this.rightButtonClicked) {
                this.selectedTag = "";
                this.clearSelection();
            } else {
                this.selectedTag = ((QTreeWidgetItem)selectedItem.get(0)).text(0);
            }
        }
        this.selectionSignal.emit();
    }

    public void mousePressEvent(QMouseEvent e) {
        this.rightButtonClicked = e.button() == Qt.MouseButton.RightButton;
        super.mousePressEvent(e);
    }
}

