/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Tag;
import com.trolltech.qt.gui.QAbstractItemView;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import java.util.ArrayList;
import java.util.List;

public class TagAssign
extends QDialog {
    private final QListWidget tagList;
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private final QLineEdit newTag;
    private final QPushButton newTagButton;
    private boolean okClicked = false;
    private final List<String> tags;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public TagAssign(List<Tag> allTags, List<String> selectedTags, boolean permitNew) {
        this.tags = new ArrayList<String>();
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "tag.png"));
        this.tagList = new QListWidget();
        this.tagList.setSortingEnabled(true);
        this.tagList.setSelectionMode(QAbstractItemView.SelectionMode.MultiSelection);
        this.newTag = new QLineEdit();
        this.newTag.textChanged.connect((Object)this, "newTagTextChanged()");
        this.newTagButton = new QPushButton(this.tr("Add"));
        this.newTagButton.setEnabled(false);
        this.newTagButton.clicked.connect((Object)this, "addTag()");
        QHBoxLayout addLayout = new QHBoxLayout();
        addLayout.addWidget((QWidget)this.newTag);
        addLayout.setStretch(0, 10);
        addLayout.addWidget((QWidget)this.newTagButton);
        if (!permitNew) {
            this.newTagButton.setVisible(false);
            this.newTag.setVisible(false);
        }
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        QHBoxLayout horizontalLayout = new QHBoxLayout();
        horizontalLayout.addWidget((QWidget)this.tagList);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Note Tags"));
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)horizontalLayout);
        mainLayout.addLayout((QLayout)addLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        if (allTags != null) {
            int i = 0;
            while (i < allTags.size()) {
                this.tags.add(allTags.get(i).getName());
                QListWidgetItem item = new QListWidgetItem(allTags.get(i).getName());
                this.tagList.addItem(item);
                if (selectedTags != null) {
                    int j = 0;
                    while (j < selectedTags.size()) {
                        String name = selectedTags.get(j);
                        if (name.equals(item.text())) {
                            item.setSelected(true);
                            j = selectedTags.size() + 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void newTagTextChanged() {
        if (this.newTag.text().equals("")) {
            this.newTagButton.setEnabled(false);
            return;
        }
        this.newTagButton.setEnabled(true);
        int i = 0;
        while (i < this.tags.size()) {
            if (this.tags.get(i).trim().equalsIgnoreCase(this.newTag.text().trim())) {
                this.newTagButton.setEnabled(false);
                return;
            }
            ++i;
        }
    }

    private void addTag() {
        String tag = this.newTag.text().trim();
        this.tagList.addItem(tag);
        this.newTag.setText("");
        this.newTagButton.setEnabled(false);
        int i = 0;
        while (i < this.tagList.count()) {
            QListWidgetItem item = this.tagList.item(i);
            if (item.text().equals(tag)) {
                item.setSelected(true);
                return;
            }
            ++i;
        }
    }

    public QListWidget getTagList() {
        return this.tagList;
    }
}

