/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.xml;

import com.evernote.edam.type.Resource;
import cx.fbn.nevernote.Global;

public class HtmlTagModifier {
    StringBuffer html;

    public HtmlTagModifier() {
        this.html = null;
    }

    public HtmlTagModifier(String data) {
        this.html = new StringBuffer(data);
    }

    public void setHtml(String data) {
        this.html = new StringBuffer(data);
    }

    public String getHtml() {
        return this.html.toString();
    }

    public void modifyLatexTagHash(Resource res) {
        int position = 0;
        while (position < this.html.length()) {
            if ((position = this.html.indexOf("<img", position)) > 0 && this.matchesGuid(position, res.getGuid())) {
                this.replaceValue(position, "height", new Integer(res.getHeight()).toString());
                this.replaceValue(position, "width", new Integer(res.getWidth()).toString());
                this.replaceValue(position, "hash", Global.byteArrayToHexString(res.getData().getBodyHash()));
                return;
            }
            ++position;
        }
    }

    private boolean matchesGuid(int position, String guid) {
        int endPosition = this.html.indexOf(">", position);
        if (endPosition < 0) {
            return false;
        }
        int guidPos = this.html.indexOf(guid, position);
        return guidPos <= endPosition;
    }

    public void replaceValue(int position, String attribute, String newValue) {
        int endPosition = this.html.indexOf(">", position);
        if (endPosition < 0) {
            return;
        }
        int attributeStart = this.html.indexOf(attribute, position);
        if (attributeStart < 0 || attributeStart > endPosition) {
            return;
        }
        int attributeEnd = this.html.indexOf(" ", attributeStart);
        if (attributeEnd < 0 || endPosition < attributeEnd) {
            attributeEnd = endPosition - 1;
        }
        attributeStart = attributeStart + 2 + attribute.length();
        this.html = this.html.delete(attributeStart, endPosition - 1);
        this.html = this.html.insert(attributeStart, newValue);
    }
}

