/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QFormLayout;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import cx.fbn.nevernote.utilities.SyncTimes;
import java.util.List;

public class ConfigConnectionPage
extends QWidget {
    private final QCheckBox autoLogin;
    private final QComboBox syncInterval;
    private final SyncTimes syncTimes;
    private final QCheckBox synchronizeOnClose;
    private final QCheckBox synchronizeDeletedContents;
    private final QLineEdit proxyHost;
    private final QSpinBox proxyPort;
    private final QLineEdit proxyUserid;
    private final QLineEdit proxyPassword;

    public ConfigConnectionPage(QWidget parent) {
        QGroupBox useridGroup = new QGroupBox(this.tr("Connection"));
        this.syncInterval = new QComboBox((QWidget)this);
        this.syncTimes = new SyncTimes();
        this.syncInterval.addItems(this.syncTimes.stringValues());
        this.autoLogin = new QCheckBox("Automatic Connect");
        this.synchronizeDeletedContents = new QCheckBox("Synchronze Deleted Note Content");
        this.synchronizeOnClose = new QCheckBox("Synchronize On Shutdown (only if connected)");
        QGroupBox proxyGroup = new QGroupBox("Proxy Settings");
        QLabel proxyHostLabel = new QLabel(this.tr("Host"));
        QLabel proxyPortLabel = new QLabel(this.tr("Port"));
        QLabel proxyUseridLabel = new QLabel(this.tr("Userid"));
        QLabel proxyPasswordLabel = new QLabel(this.tr("Password"));
        this.proxyHost = new QLineEdit();
        this.proxyPort = new QSpinBox();
        this.proxyUserid = new QLineEdit();
        this.proxyPassword = new QLineEdit();
        this.proxyPassword.setEchoMode(QLineEdit.EchoMode.Password);
        this.proxyHost.setText(Global.getProxyValue("url"));
        String portString = Global.getProxyValue("port");
        Integer port = new Integer(80);
        try {
            port = new Integer(portString.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.proxyPort.setMinimum(1);
        this.proxyPort.setMaximum(65565);
        this.proxyPort.setValue(port.intValue());
        this.proxyUserid.setText(Global.getProxyValue("userid"));
        this.proxyPassword.setText(Global.getProxyValue("password"));
        if (!this.proxyHost.text().trim().equals("") && this.proxyPort.text().trim().equals("")) {
            this.proxyPort.setValue(80);
        }
        QFormLayout useridLayout = new QFormLayout();
        useridLayout.addWidget((QWidget)new QLabel(this.tr("Syncronization Interval")));
        useridLayout.addWidget((QWidget)this.syncInterval);
        useridLayout.addWidget((QWidget)this.autoLogin);
        useridLayout.addWidget((QWidget)this.synchronizeOnClose);
        useridLayout.addWidget((QWidget)this.synchronizeDeletedContents);
        QGridLayout proxyLayout = new QGridLayout();
        proxyLayout.addWidget((QWidget)proxyHostLabel, 1, 1);
        proxyLayout.addWidget((QWidget)this.proxyHost, 1, 2);
        proxyLayout.addWidget((QWidget)proxyPortLabel, 2, 1);
        proxyLayout.addWidget((QWidget)this.proxyPort, 2, 2);
        proxyLayout.addWidget((QWidget)proxyUseridLabel, 3, 1);
        proxyLayout.addWidget((QWidget)this.proxyUserid, 3, 2);
        proxyLayout.addWidget((QWidget)proxyPasswordLabel, 4, 1);
        proxyLayout.addWidget((QWidget)this.proxyPassword, 4, 2);
        useridGroup.setLayout((QLayout)useridLayout);
        proxyGroup.setLayout((QLayout)proxyLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addWidget((QWidget)useridGroup);
        mainLayout.addWidget((QWidget)proxyGroup);
        mainLayout.addStretch(1);
        this.setLayout((QLayout)mainLayout);
    }

    public void setAutomaticLogin(boolean val) {
        this.autoLogin.setChecked(val);
    }

    public boolean getAutomaticLogin() {
        return this.autoLogin.isChecked();
    }

    public void setSyncronizeDeletedContent(boolean val) {
        this.synchronizeDeletedContents.setChecked(val);
    }

    public boolean getSynchronizeDeletedContent() {
        return this.synchronizeDeletedContents.isChecked();
    }

    public String getProxyUrl() {
        return this.proxyHost.text().trim();
    }

    public String getProxyPort() {
        if (!this.proxyHost.text().trim().equalsIgnoreCase("") && this.proxyPort.text().trim().equals("")) {
            return "80";
        }
        if (this.proxyHost.text().trim().equals("")) {
            return "";
        }
        return this.proxyPort.text().trim();
    }

    public String getProxyUserid() {
        if (this.proxyHost.text().trim().equals("")) {
            return "";
        }
        return this.proxyUserid.text().trim();
    }

    public String getProxyPassword() {
        if (this.proxyHost.text().trim().equals("")) {
            return "";
        }
        return this.proxyPassword.text().trim();
    }

    public boolean getSynchronizeOnClose() {
        return this.synchronizeOnClose.isChecked();
    }

    public void setSynchronizeOnClose(boolean val) {
        this.synchronizeOnClose.setChecked(val);
    }

    public String getSyncInterval() {
        int i = this.syncInterval.currentIndex();
        return this.syncInterval.itemText(i);
    }

    public void setSyncInterval(String s) {
        List<String> vals = this.syncTimes.stringValues();
        int i = 0;
        while (i < vals.size()) {
            if (vals.get(i).equalsIgnoreCase(s)) {
                this.syncInterval.setCurrentIndex(i);
            }
            ++i;
        }
    }
}

