<?php
/**
 * SmartyѤơ
 * ƥץ졼ȤؤͤȲɽԤΥ饹Ǥ
 * 
 * @author YAMAOKA Hiroyuki
 * @package moony.core
 */
class Moony_View {

	/** @var object Smarty饹Υ󥹥 */
	var $_smarty;

	/** @var array ƥץ졼Ȥꤹѥ᡼ */
	var $_items;

	/** @var string ̾ */
	var $_action_name;

	/**
	 * 󥹥ȥ饯Ǥ
	 * 
	 * @access public
	 */
	function Moony_View() {
	}

	/**
	 * Ԥޤ
	 * 
	 * @access public
	 * @param string $action_name ̾
	 */
	function init($action_name) {

		$this->_smarty =& new Smarty();

		$this->_smarty->template_dir = MOONY_SMARTY_TEMPLATE_DIR;
		$this->_smarty->compile_dir = MOONY_SMARTY_COMPILE_DIR;

		$this->_items = array();
		$this->_action_name = $action_name;
	}

	/**
	 * ƥץ졼Ȥꤹѥ᡼ꤷޤ
	 * 
	 * @access public
	 * @param string $key ѥ᡼
	 * @param mixed $value ѥ᡼
	 */
	function assign($key, $value) {
		$this->_items[$key] = $value;
	}

	/**
	 * ƥץ졼ɽԤޤ
	 * 
	 * @access public
	 * @param string $name ƥץ졼ȥե̾ʥǥե<code>null</code>
	 */
	function forward($name = null) {

		if (strlen($name) == 0) {
			$this->display($this->_action_name . '.' . MOONY_SMARTY_TEMPLATE_EXT);
			return;
		}

		$this->display($this->_action_name . ucfirst($name) . '.' . MOONY_SMARTY_TEMPLATE_EXT);
    }

	/**
	 * ƥץ졼Ȥ˥ѥ᡼ꤷɽԤޤ
	 * 
	 * @access private
	 * @param string $template ƥץ졼ȥե̾
	 */
	function display($template) {

		// ¸ߥå
		$file = $this->_smarty->template_dir . '/' . $template;
		if (!file_exists($file)) {
			header('HTTP/1.0 404 Not Found');
			exit;
		}

		foreach ($this->_items as $key => $value) {
			$this->_smarty->assign($key, $value);
		}

		$this->_smarty->display($template);
    }
}
?>