<?php
/**
 * HTTPåǼ륯饹Ǥ
 * 
 * @access public
 * @author YAMAOKA Hiroyuki
 * @package moony.core
 */
class Moony_Session {

	/** @var bool å󤬳ϤƤ뤫ɤ */
	var $_has_started = false;

	/**
	 * 󥹥ȥ饯Ǥ
	 * 
	 * @access public
	 */
	function Moony_Session() {
	}

	/**
	 * å򳫻Ϥޤ
	 * 
	 * @access public
	 */
	function start() {
		session_start();
		$this->_has_started = true;
	}

	/**
	 * åλޤ
	 * 
	 * @access public
	 * @return ˽λ<code>true</code>
	 */
	function destroy() {

		if (!$this->_has_started) {
			return true;
		}

		$_SESSION = array();

		if (isset($_COOKIE[session_name()])) {
			setcookie(session_name(), '', time() - 42000, '/');
		}

		session_destroy();
		$this->_has_started = false;

		return true;
	}

	/**
	 * å˳Ǽ줿ͤޤ
	 * ꤵ줿ɳդͤꤵƤʤ硢
	 * ֤ͤޤ
	 * 
	 * @access public
	 * @param string $key Ǽ
	 * @param mixed $alt 
	 * @return Ǽ
	 */
	function get($key, $alt = null) {

		if (!$this->_has_started) {
			return $alt;
		}

		if (!isset($_SESSION[$key])) {
			return $alt;
		}

		return $_SESSION[$key];
	}

	/**
	 * åͤꤷޤ
	 * 
	 * @access public
	 * @param string $key Ǽ
	 * @param mixed $value Ǽ
	 * @return bool ˽λ<code>true</code>
	 */
	function set($key, $value) {

		if (!$this->_has_started) {
			return false;
		}

		$_SESSION[$key] = $value;
		return true;
	}

	/**
	 * å󤫤ͤޤ
	 * 
	 * @access public
	 * @param string $key Ǽ
	 * @return bool ˽λ<code>true</code>
	 */
	function remove($key) {

		if (!$this->_has_started) {
			return false;
		}

		unset($_SESSION[$key]);
		return true;
	}
}
?>