// -*- mode: c++ -*-

#ifndef MiX_DOCUMENT_H_
#define MiX_DOCUMENT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "extern/noncopyable.hpp"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class Document : boost::noncopyable,
		   public NodeContainer<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef Document<charT,char_traits,xml_traits> this_type;
    typedef typename nodelist_type::iterator nodelist_iter; 
    typedef NodeContainer<charT,char_traits,xml_traits> nodecontainer_type;
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * RXgN^
     *
     * Document̃RXgN^͒ڌĂׂ܂B
     * Document<...>::createŐĂ
     */
    Document() { };
  public:
    ///fXgN^
    virtual ~Document()throw() { };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType() const{ return Node_Document; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_DocumentԂ܂
     */
    static NodeType type(){ return Node_Document; } ;
    ///B̎qElementԂ܂
    element_type& getRoot()const;
    /**
     * Document̕\𓾂܂
     *
     * SXMLꍇ͂Ăт܂<br>
     * bIndent^̎Cfgǉ܂B
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;
    /**
     * qAttributeɃANZX܂
     *
     * szNameŗ^ꂽOAttributeւ̎QƂԂ܂<br>
     * ȂꍇDomException<...>𓊂܂
     */
    attribute_type& operator[](const string_type& name){
      return getAttribute(name);
    }
    /**
     * Document𕡐܂
     */
    node_type& clone(nodecontainer_type& dmy,const nodelist_iter& it=dmy_it)const { return clone(); }

    /**
     * Document𕡐܂
     */
    node_type& clone() const;
    /**
     * Document𐶐܂
     *
     * DocumentƓɗB̎qElement܂
     * \param rootname ɐqElement̖O
     */
    static this_type& create(const string_type& rootname);
    
    friend class DOM_Parser<charT,char_traits,xml_traits>;
  };
}

#ifndef MiX_DOCUMENT_CPP_
#include "Document.cpp"
#endif

#endif
