#include "common.h"

cMenu* gActiveMenu;
map<string, cMenu*> gMenu;

void cMenu::Final()
{
TBEGIN();

    for(map<string, cMenu*>::iterator i = gMenu.begin();
         i != gMenu.end();
         i++)
    {
        delete i->second;
    }

TEND();    
}

cMenu::cMenu(char* title)
{
TBEGIN();

    strcpy(mTitle, title);

    mCursor = 0;

TEND();    
}

cMenu::~cMenu()
{
}

void cMenu::Append(string name, int key, string cmd)
{
TBEGIN();

    char buf[256];
    sprintf(buf, " %-40s", name.c_str());
    mMIName.push_back(buf);
    mMIKey.push_back(key);
    mMICmd.push_back(cmd);

TEND();    
}

void cMenu::Input(int meta, int key)
{
TBEGIN();

    if(key == 1 || key == KEY_HOME) {        // CTRL-A
        mCursor = 0;
    }
    else if(key == 5 || key == KEY_END) {    // CTRL-E
        mCursor = mMIKey.size()-1;
    }
    else if(key == 14 || key == KEY_DOWN) {    // CTRL-N
        mCursor++;

        if(mCursor >= mMIKey.size()) {
            mCursor = 0;
        }
    }
    else if(key == 16 || key == KEY_UP) {    // CTRL-P
        mCursor--;

        if(mCursor < 0) {
            mCursor = mMIKey.size()-1;
        }
    }
    else if(key == 3 || key == 7 || key == 27) {    // CTRL-C CTRL-G Escape
        gActiveMenu = NULL;
        delwin(mScr);
        mScr = NULL;
    }
    else if(key == 10 || key == 13) {    // CTRL-M CTRL-J
        rb_eval_string(mMICmd[mCursor].c_str());

        gActiveMenu = NULL;
        delwin(mScr);
        mScr = NULL;
    }
    else if(key == 12) {// CTRL-L
        clear();
        gLDir->Reread();
        gRDir->Reread();
    }
    else {
        for(int i=0; i<mMIKey.size(); i++) {
            if(mMIKey[i] == key) {
                rb_eval_string(mMICmd[i].c_str());
            }
        }
        
        gActiveMenu = NULL;
        delwin(mScr);
        mScr = NULL;
    }

TEND();    
}

void cMenu::View()
{
TBEGIN();

    wmyclear(mScr);

    box(mScr, '|', '-');

    wattron(mScr, A_BOLD);
    mvwprintw(mScr, 0, 2, mTitle);
    wattroff(mScr, A_BOLD);

    for(int i=0; i<mMIName.size(); i++) {
        if(i == mCursor) {
            wattron(mScr, A_REVERSE);
            mvwprintw(mScr, i+1, 2, mMIName[i].c_str());
            wattroff(mScr, A_REVERSE);
        }
        else  {
            mvwprintw(mScr, i+1, 2, mMIName[i].c_str());
        }
    }

    wrefresh(mScr);

TEND();    
}

void cMenu::Show()
{
TBEGIN();

    mScr = newwin(mMIName.size() + 2, 45, 0, 2);
    mCursor = 0;

TEND();
}
