<?php

/***********************************************************
 * ƥѥ饤֥
 *
 * $Id: libcalendar.php 4722 2012-12-25 05:07:47Z kawamura $
 * $Revision: 4722 $
 * $Date:: 2012-12-25 14:07:47 +0900#$
 **********************************************************/

/* ޥ */
define("ETCDIR", "etc/");
define("BASEDIR", "/usr/medaca/");

/* ե̾ */
define("CALCONF", "medaca.conf");

/* եDBType */
define("DBTYPE_LDAP", "LDAP");

/* URLǧ */
define("LIGHTNING", "0");
define("IPHONE",    "1");
define("URL_CALENDARS",  "calendars");
define("URL_PRINCIPALS", "principals");
define("URL_SPLIT_IPHONE_MIN"   , "3");
define("URL_SPLIT_IPHONE_MAX"   , "4");
define("URL_SPLIT_LIGHTNING_MIN", "4");
define("URL_SPLIT_LIGHTNING_MAX", "5");

/* syslog */
define("IDENT", "medaca");

/* ѥ֥̾ */
define("OBJNAME_CALRESOURCE",   "calendarResource");
define("OBJNAME_CALCOLLECTION", "calendarCollection");
define("OBJNAME_CALDATA",       "calendarData");

/* ̾ */
define("OBJECTCLASS",           "objectClass");
define("CALRESOURCE",           "resource");
define("COLLECTIONCOUNT",       "collectionCount");
define("CALADMINU",             "calendarAdminU");
define("CALCOLLECTION",         "collection");
define("CALACTIVE",             "collectionActive");
define("CALAUTHORITYDEF",       "authorityDefault");
define("CALAUTHORITYORDER",     "authorityOrder");
define("CALAUTHORITYARTICLE",   "authorityArticle");
define("CALCTAG",               "calendarCTag");
define("CALOBJURI",             "calObjectUri");
define("CALOBJDATA",            "calData");
define("CALMODTIME",            "calTime");
define("COLLECTIONNUMMAX",      "collectionNumMax");
define("COLLECTIONNUMBER",     "collectionNumber");
define("COLLECTIONDESCRIPTION", "collectionDescription");

/* 桼̾Ĺ */
define("NAME_MIN", 1);
define("NAME_MAX", 20);

/* ꥽̾Ĺ */
define("RESOURCE_NAME_MIN", 1);
define("RESOURCE_NAME_MAX", 20);

/* 쥯̾Ĺ */
define("COLLECTION_NAME_MIN", 1);
define("COLLECTION_NAME_MAX", 20);

/* ؿ */
define("FUNC_TRUE",   "1");
define("FUNC_FALSE",  "0");
define("FUNC_SYSERR", "-1");

/*  */
define("RETTYPE_ONE",  "0");
define("RETTYPE_MANY", "1");

/* ¤ο */
define("AUTHREADONLY",    "0");
define("AUTHREADWRITE",   "1");
define("AUTHRESTRICTION", "2");

/* ƥ֥ե饰 */
define("COLLECTION_ACTIVE",   1);
define("COLLECTION_INACTIVE", 0);

/* ưե饰 */
define("AUTOCREATE_ON",  "1");
define("AUTOCREATE_OFF", "0");

/* authorityArticleΥ桼 */
define("ARTICLE_SEP", "U");
/* authorityArticleΥǥեID */
define("ARTICLE_DEF_ID", "0");

/* collection=home */
define("COLLHOME", "home");

/* authorityDefaultΥǥե */
define("CALAUTHORITYDEF_DEF", "0");

/* calendarCtagΥǥե */
define("CALCTAG_DEF", "0");

/* collectionCountΥǥե */
define("COLLECTIONCOUNT_DEF", "1");

/* collectionNumMaxΥǥե */
define("COLLECTIONNUMMAX_DEF", "1");

/* collectionNumberΥǥե */
define("COLLECTIONNUMBER_DEF", "1");

/* ꥽ɲü */
define("RESO_FALSE", "-1");

/* 쥯ɲü */
define("COLL_FALSE", "-2");

/* CALDAV */
define("CALDAV_VEVENT",       "VEVENT");
define("CALDAV_VTODO",        "VTODO");
define("CALDAV_ID",           "id");
define("CALDAV_URI",          "uri");
define("CALDAV_PRINCIPALURI", "principaluri");
define("CALDAV_CALENDARID_DEF",     "1");
define("CALDAV_CALENDARDATA", "calendardata");
define("CALDAV_CALENDARID",   "calendarid");
define("CALDAV_LASTMODIFIED", "lastmodified");
define("CALDAV_ID_NUM",           0);
define("CALDAV_CALENDARDATA_NUM", 1);
define("CALDAV_URI_NUM",          2);
define("CALDAV_CALENDARID_NUM",   3);
define("CALDAV_LASTMODIFIED_NUM", 4);

/*********************************************************
 * read_calendar_conf()
 *
 * եɤ߹ߤԤ
 *
 * []
 *       $calendar_conf ե(Ϥ)
 * [֤]
 *       TRUE         
 *       FALSE        եɤ߹߰۾
 **********************************************************/
function read_calendar_conf(&$calendar_conf)
{
    /* ե */
    $conf_keys = array(
                    "syslogfacility"            => "DgCommon_is_facility",
                    "dbtype"                    => "dbtype_check",
                    "ldapserver"                => "DgCommon_check_none",
                    "ldapport"                  => "DgCommon_check_none",
                    "ldapbinddn"                => "DgCommon_check_none",
                    "ldapbindpw"                => "DgCommon_check_none",
                    "ldapbasedn"		=> "DgCommon_check_none",
                    "autoresourcecreate"	=> "DgCommon_is_bool",
                    "autocreatecollectionname"	
						=> "check_collection_name",
                    );

    /* Υǥե */
    $conf_def = array(
                    "syslogfacility"            => "local1",
                    "ldapserver"                => "localhost",
                    "ldapport"                  => "389",
                    "autoresourcecreate"        => "1",
		    "autocreatecollectionname"  => "home"
                    );

    /* եɤ߹ */
    $filepath = BASEDIR . ETCDIR . CALCONF;
    $calendar_conf = DgCommon_read_conf($filepath, $conf_keys, $conf_def);
    if ($calendar_conf === FALSE) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * dbtype_check()
 *
 * DBtypeå
 *
 * []
 *      $dbtype         DBtype
 * [֤]
 *      TRUE            
 *      FALSE           ۾
 **********************************************************/
function dbtype_check($dbtype)
{
    $checkarray = array(DBTYPE_LDAP);
    
    $ret = array_search($dbtype, $checkarray);
    if ($ret === FALSE) {
        return FALSE;
    }

    return TRUE;
}

/***********************************************************
 * result_log()
 *
 * եФ顼ϤԤ
 *
 * []
 *      $resultlog      顼å
 * [֤]
 *      ʤ
 ************************************************************/
function result_log($resultlog)
{
    global $calendar_conf;

    /* ե뤬ɤ߹ޤꤵƤ */
    if (isset($calendar_conf['syslogfacility']) ) {
        /* ̾ */
        $syslog = DgCommon_set_logfacility($calendar_conf['syslogfacility']);

        if (!isset($syslog)) {
            $syslog = LOG_LOCAL1;
        }
    } else {
        /* ե뤬ɤ߹ޤʤä */
        $syslog = LOG_LOCAL1;
    }

    /* 񤭹ߤƤ˥ɽ̾桼̾硣*/
    $user = "";
    if (isset($_SERVER['REMOTE_USER'])) {
        $user = $_SERVER['REMOTE_USER'];
    }
    $msg = $user . " " . $resultlog . "\n";

    /* ץ */
    $ret = openlog(IDENT, LOG_PID, $syslog);
    if ($ret === FALSE) {
        return;
    }

    /*  */
    syslog(LOG_ERR, $msg);
    closelog();

    return;
}

/*********************************************************
 * check_user()
 *
 * HTTPꥯȤ桼̾ǧ
 *
 * []
 *       ʤ
 * [֤]
 *       TRUE         
 *       FALSE        ۾(ǧڤ̤äƤʤ)
 **********************************************************/
function check_user()
{
    global $dg_log_msg;

    /* 桼Ȥγǧ */
    if (isset($_SERVER["PHP_AUTH_USER"]) === FALSE &&
        isset($_SERVER["PHP_AUTH_PW"]) === FALSE ) {
        /* ǧڤƤʤ */
        $dg_log_msg = "Authentication is not being used.";
        return FALSE;
    }

    /* ǧ */
    $ret = check_user_name($_SERVER["PHP_AUTH_USER"]);
    if ($ret === FALSE) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * check_auth_digest()
 *
 * ǧˡDIGESTǧڤǤ뤳Ȥǧ
 *
 * []
 *       ʤ
 * [֤]
 *       TRUE         
 *       FALSE        ۾(ǧڤ̤äƤʤ)
 **********************************************************/
function check_auth_digest()
{
    global $dg_log_msg;

    if (empty($_SERVER['PHP_AUTH_DIGEST'])) {
        /* ǧڤƤʤ */
        $dg_log_msg = "Authentication is not being used.";
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * get_username()
 *
 * 饤Ȥ줿AuthorizationפƤ桼̾
 *
 * []
 *       ʤ
 * [֤]
 *       $username    桼̾
 *       FALSE        ʷ
 **********************************************************/
function get_username()
{
    $username = "";

    /* 桼̾ */
    $response   = explode(",", str_replace('"', '', $_SERVER['PHP_AUTH_DIGEST']));
    $tmp = null;
    foreach ($response as $v) {
        $tmp = explode("=", trim($v));
        if ($tmp[0] === "username") {
            $username  = $tmp[1];
            break;
        }
    }

    /* ǧ */
    $ret = check_user_name($username);
    if ($ret === FALSE) {
        return FALSE;
    }

    return $username;
}

/*********************************************************
 * check_url()
 *
 * HTTPꥯȤURIǧresource,collectionμ
 *
 * []
 *       $resource    ꥽̾(Ϥ)
 *       $collection  쥯̾(Ϥ)
 * [֤]
 *       TRUE         
 *       FALSE        ۾(ꤵƤѥ۾)
 **********************************************************/
function check_url(&$resource, &$collection)
{
    global $dg_log_msg;
    global $access_type;

    /*  */
    $calendars  = "";
    $resource   = "";
    $collection = "";
    $min = URL_SPLIT_LIGHTNING_MIN;
    $max = URL_SPLIT_LIGHTNING_MAX;

    /* PATHʬ */
    $tmp = explode("/", $_SERVER["PATH_INFO"]);
    if (strcmp($tmp[1], URL_PRINCIPALS) == 0) {
        $min = URL_SPLIT_IPHONE_MIN;
        $max = URL_SPLIT_IPHONE_MAX;
        $access_type = IPHONE;
    }
    $tmpcount = count($tmp);
    if ($tmpcount != $min && $tmpcount != $max) {
        /* ꤷƤѥ㤦 */
        $dg_log_msg = "Invalid URI.(" . $_SERVER["PATH_INFO"] . ")";
        return FALSE;
    }

    $calendars  = $tmp[1];
    $resource   = $tmp[2];
    $collection = $tmp[3];

    /* ѥγǧ */
    if ($access_type == IPHONE) {
        if ($collection != "") {
            $dg_log_msg = "Invalid URI.(" . $_SERVER["PATH_INFO"] . ")";
            return FALSE;
        }
    } else if (strcmp($calendars, URL_CALENDARS) != 0) {
        /* ꤷƤѥ㤦 */
        $dg_log_msg = "Invalid URI.(" . $_SERVER["PATH_INFO"] . ")";
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * check_user_name()
 *
 * 桼̾ηǧ
 *
 * []
 *       $name        桼̾
 * [֤]
 *       TRUE         
 *       FALSE        ۾
 **********************************************************/
function check_user_name($name)
{
    global $dg_log_msg;

    /* Ĺå */
    $len = strlen($name);
    if ($len < NAME_MIN || $len > NAME_MAX) {
        $dg_log_msg = "Invalid user name.($name)";
        return FALSE;
    }

    /* ȾѱѾʸʸ[-_.]Τߵ */
    $num = "0123456789";
    $sl = "abcdefghijklmnopqrstuvwxyz";
    $ll = strtoupper($sl);
    $sym = "-_.";
    $allow_letter = $num . $sl . $ll . $sym;
    if (strspn($name, $allow_letter) != $len) {
        $dg_log_msg = "Invalid user name.($name)";
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * check_resource_name()
 *
 * ꥽̾ηǧ
 *
 * []
 *       $name        ꥽̾
 * [֤]
 *       TRUE         
 *       FALSE        ۾
 **********************************************************/
function check_resource_name($name)
{
    global $dg_log_msg;

    /* Ĺå */
    $len = strlen($name);
    if ($len < RESOURCE_NAME_MIN || $len > RESOURCE_NAME_MAX) {
        $dg_log_msg = "Invalid resource name.(" . $_SERVER["PATH_INFO"] . ")";
        return FALSE;
    }

    /* ȾѱѾʸʸ[-_.]Τߵ */
    $num = "0123456789";
    $sl = "abcdefghijklmnopqrstuvwxyz";
    $ll = strtoupper($sl);
    $sym = "-_.";
    $allow_letter = $num . $sl . $ll . $sym;
    if (strspn($name, $allow_letter) != $len) {
        $dg_log_msg = "Invalid resource name.(" . $_SERVER["PATH_INFO"] . ")";
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * check_collection_name()
 *
 * 쥯̾ηǧ
 *
 * []
 *       $name        쥯̾
 * [֤]
 *       TRUE         
 *       FALSE        ۾
 **********************************************************/
function check_collection_name($name)
{
    global $dg_log_msg;

    /* Ĺå */
    $len = strlen($name);
    if ($len < COLLECTION_NAME_MIN || $len > COLLECTION_NAME_MAX) {
        $dg_log_msg = "Invalid collection name.(" . $_SERVER["PATH_INFO"] . ")";
        return FALSE;
    }

    /* ȾѱѾʸʸ[-_.]Τߵ */
    $num = "0123456789";
    $sl = "abcdefghijklmnopqrstuvwxyz";
    $ll = strtoupper($sl);
    $sym = "-_.";
    $allow_letter = $num . $sl . $ll . $sym;
    if (strspn($name, $allow_letter) != $len) {
        $dg_log_msg = "Invalid collection name.(" . $_SERVER["PATH_INFO"] . ")";
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * get_resource()
 *
 * ꤷ꥽LDAP
 *
 * []
 *       $dg_ldapid    ID
 *       $resource     ꥽̾
 *       $ldapdata     LDAPǡ(Ϥ)
 * [֤]
 *       FUNC_TRUE      LDAP򸫤Ĥ
 *       FUNC_FALSE     LDAP󤬸Ĥʤä
 *       FUNC_SYSERR    ۾郎ȯ
 **********************************************************/
function get_resource($dg_ldapid, $resource, &$ldapdata)
{
    global $dg_log_msg;
    global $calendar_conf;

    /* filter */
    $filter = sprintf("%s=%s",
                      CALRESOURCE, DgLDAP_filter_escape($resource));
    $attrs = array();
    $scope = TYPE_ONEENTRY;
    $dn = sprintf("%s=%s,%s",
                   CALRESOURCE, LDAP_dn_escape($resource),
                   $calendar_conf["ldapbasedn"]);

    /* LDAPξ */
    $data = array();
    $ret = DgLDAP_get_entry_batch($dn, $dg_ldapid,
                                  $filter, $attrs, $scope, $data);
    if ($ret == LDAP_ERR_NODATA) {
        return FUNC_FALSE;
    } elseif ($ret != LDAP_OK) {
        return FUNC_SYSERR;
    }

    $ldapdata = $data[0];

    return FUNC_TRUE;
}

/*********************************************************
 * ldap_calendar_add()
 *
 * ǡɲä
 *
 * []
 *       $resource          ꥽̾
 *       $collection쥯̾
 *       $objecturi ID
 *       $caldata           
 *
 * [֤]
 *       TRUE               ɲ
 *       FALSE              ɲü
 **********************************************************/
function ldap_calendar_add($resource, $collection, $objecturi, $caldata)
{
    global $calendar_conf;
    global $dg_log_msg;
    global $dg_ldapid;

    /* dn  */
    $dn = sprintf("%s=%s,%s=%s,%s=%s,%s",
                  CALOBJURI, LDAP_dn_escape($objecturi),
                  CALCOLLECTION, LDAP_dn_escape($collection),
                  CALRESOURCE, LDAP_dn_escape($resource),
                  $calendar_conf["ldapbasedn"]);

    /* LDAP ɲ */
    $ret = DgLDAP_add_entry_batch($dn, $dg_ldapid, $caldata);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * ldap_calendar_mod()
 *
 * ǡѹ
 *
 * []
 *       $resource          ꥽̾
 *       $collection쥯̾
 *       $objecturi ID
 *       $caldata           
 *
 * [֤]
 *       TRUE               ѹ
 *       FALSE              ѹ
 **********************************************************/
function ldap_calendar_mod($resource, $collection, $objecturi, $caldata)
{
    global $calendar_conf;
    global $dg_ldapid;

    /* dn  */
    $dn = sprintf("%s=%s,%s=%s,%s=%s,%s",
                  CALOBJURI, LDAP_dn_escape($objecturi),
                  CALCOLLECTION, LDAP_dn_escape($collection),
                  CALRESOURCE, LDAP_dn_escape($resource),
                  $calendar_conf["ldapbasedn"]);

    /* LDAP ѹ */
    $ret = DgLDAP_mod_entry_batch($dn, $dg_ldapid, $caldata);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * ldap_calendar_del()
 *
 * ǡѹ
 *
 * []
 *       $resource          ꥽̾
 *       $collection쥯̾
 *       $objecturi ID
 *
 * [֤]
 *       TRUE               
 *       FALSE              
 **********************************************************/
function ldap_calendar_del($resource, $collection, $objecturi)
{
    global $calendar_conf;
    global $dg_ldapid;

    /* dn  */
    $dn = sprintf("%s=%s,%s=%s,%s=%s,%s",
                  CALOBJURI, LDAP_dn_escape($objecturi),
                  CALCOLLECTION, LDAP_dn_escape($collection),
                  CALRESOURCE, LDAP_dn_escape($resource),
                  $calendar_conf["ldapbasedn"]);

    /* LDAP  */
    $ret = DgLDAP_del_entry_batch($dn, $dg_ldapid);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************
 * ldap_collection_ctag_update()
 *
 * collectionˤCTAG򹹿
 *
 * []
 *       $resource          ꥽̾
 *       $collection쥯̾
 *       $ctag              CTag
 *
 * [֤]
 *      TRUE     
 *      FALSE    ۾
 **********************************************************/
function ldap_collection_ctag_update($resource, $collection, $ctag)
{
    global $calendar_conf;
    global $dg_ldapid;

    /* collectionξ򹹿 */
    /* dn  */
    $dn = sprintf("%s=%s,%s=%s,%s",
                  CALCOLLECTION, LDAP_dn_escape($collection),
                  CALRESOURCE, LDAP_dn_escape($resource),
                  $calendar_conf["ldapbasedn"]);

    /* CTag */
    $data[CALCTAG] = $ctag;

    /* LDAP  */
    $ret = DgLDAP_mod_entry_batch($dn, $dg_ldapid, $data);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************************
 * set_ldapinfo
 *
 * ldapinfo
 *
 * []
 *      ʤ
 *
 * [֤]
 *      TRUE             
 **********************************************************************/
function set_ldapinfo()
{
    global $calendar_conf;
    global $dg_ldapinfo;

    /* LDAPФIPɥ쥹 */
    $dg_ldapinfo["ldapserver"] = $calendar_conf["ldapserver"];

    /* LDAPФΥݡֹ */
    $dg_ldapinfo["ldapport"] = $calendar_conf["ldapport"];

    /* LDAPФΥХDN */
    $dg_ldapinfo["ldapbinddn"] = $calendar_conf["ldapbinddn"];

    /* LDAPФΥХɥѥ */
    $dg_ldapinfo["ldapbindpw"] = $calendar_conf["ldapbindpw"];

    /* ʬȤؤΥХ(ͭ: TRUE ̵: FALSE) */
    $dg_ldapinfo["ldapuserself"] = FALSE;

    /* ʬȤإХɤΥХDN */
    $dg_ldapinfo["ldapuserselfdn"] = "";

    /* ʬȤإХɤΥХɥѥ */
    $dg_ldapinfo["ldapuserselfpw"] = "";

    /* read-onlyФؤΥХ(ͭ: TRUE ̵: FALSE) */
    $dg_ldapinfo["ldapro"] = FALSE;

    /* read-onlyФIPɥ쥹 */
    $dg_ldapinfo["ldapserverro"] = "";

    /* read-onlyФΥݡֹ */
    $dg_ldapinfo["ldapportro"] = "";

    return TRUE;
}

 /********************************************************************
 * ldap_connect_server()
 *
 * LDAP³
 *
 * []
 *      $ds         ID(Ϥ)
 *
 * [֤]
 *      TRUE        
 *      FALUSE      ۾
 *********************************************************************/
function ldap_connect_server(&$ds)
{
    global $calendar_conf;

    /* ldapinfoͤ */
    set_ldapinfo();

    /* LDAP³ */
    $ds = DgLDAP_connect_server();
    if ($ds == LDAP_ERR_BIND) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************************
 * search_all_calendar()
 *
 * LDAP饳쥯۲ˤƤΥ򸡺
 *
 * []
 *      $resource        ꥽̾
 *      $collection      쥯̾
 *      $caldata         (Ϥ)
 *
 * [֤]
 *      TRUE             
 *      FALUSE           
 **********************************************************************/
function search_all_calendar($resource, $collection, &$caldata)
{
    global $calendar_conf;
    global $dg_ldapid;
    global $access_type;

    /* ١DN */
    $basedn = sprintf("%s=%s,%s=%s,%s", CALCOLLECTION,
                      LDAP_dn_escape($collection), CALRESOURCE,
                      LDAP_dn_escape($resource), $calendar_conf["ldapbasedn"]);

    /* ե륿 */
    $filter = "(" . OBJECTCLASS . "=" . OBJNAME_CALDATA . ")";
    if ($access_type == IPHONE) {

    }

    /* °̾ */
    $attrs = array();

    /*  */
    $type = TYPE_ONELEVEL;

    $ret = DgLDAP_get_entry_batch($basedn, $dg_ldapid, $filter,
                                  $attrs, $type, $caldata);
    if ($ret != LDAP_OK && $ret != LDAP_ERR_NODATA) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************************
 * search_calendar()
 *
 * LDAP饫򸡺
 *
 * []
 *      $objecturi       ID
 *      $resource        ꥽̾
 *      $collection      쥯̾
 *      $caldata         (Ϥ)
 *
 * [֤]
 *      TRUE             
 *      FALUSE           
 **********************************************************************/
function search_calendar($objecturi, $resource, $collection, &$caldata)
{
    global $calendar_conf;
    global $dg_ldapid;

    /* ١DN */
    $basedn = sprintf("%s=%s,%s=%s,%s=%s,%s",
                      CALOBJURI, LDAP_dn_escape($objecturi),
                      CALCOLLECTION, LDAP_dn_escape($collection),
                      CALRESOURCE, LDAP_dn_escape($resource),
                      $calendar_conf["ldapbasedn"]);

    /* ե륿 */
    $filter = "(" . OBJECTCLASS . "=" . OBJNAME_CALDATA . ")";

    /* °̾ */
    $attrs = array(CALMODTIME, CALOBJDATA);

    /*  */
    $type = TYPE_ONEENTRY;

    $ret = DgLDAP_get_entry_batch($basedn, $dg_ldapid, $filter,
                                  $attrs, $type, $caldata);
    if ($ret != LDAP_OK && $ret != LDAP_ERR_NODATA) {
        return FALSE;
    }

    return TRUE;
}

/*********************************************************************
 * get_collection()
 *
 * 쥯
 *
 * []
 *      $resource        ꥽̾
 *      $collection      쥯̾
 *      $attrs           °̾
 *      $colledata       쥯(Ϥ
 *
 * [֤]
 *       FUNC_TRUE      LDAP򸫤Ĥ
 *       FUNC_FALSE     LDAP󤬸Ĥʤä
 *       FUNC_SYSERR    ۾郎ȯ
 ********************************************************************/
function get_collection($resource, $collection, $attrs, &$colledata)
{
    global $calendar_conf;
    global $dg_ldapid;
    global $dg_log_msg;

    /* ١DN */
    $basedn = sprintf("%s=%s,%s=%s,%s",
                      CALCOLLECTION, LDAP_dn_escape($collection),
                      CALRESOURCE, LDAP_dn_escape($resource),
                      $calendar_conf["ldapbasedn"]);

    /* ե륿 */
    $filter = "(" . OBJECTCLASS . "=" .  OBJNAME_CALCOLLECTION . ")";

    /*  */
    $type = TYPE_ONEENTRY;

    $ret = DgLDAP_get_entry_batch($basedn, $dg_ldapid, $filter, $attrs,
                                  $type, $colledata);
    if ($ret == LDAP_ERR_NODATA) {
        return FUNC_FALSE;
    } elseif ($ret != LDAP_OK) {
        return FUNC_SYSERR;
    }

    return FUNC_TRUE;
}

/*********************************************************************
 * get_collection_principals()
 *
 * 쥯(iPhone)
 *
 * []
 *      $resource        ꥽̾
 *      $filter		 ե륿
 *      $attrs		 °̾
 *      $colledata       쥯(Ϥ
 *
 * [֤]
 *       FUNC_TRUE      LDAP򸫤Ĥ
 *       FUNC_FALSE     LDAP󤬸Ĥʤä
 *       FUNC_SYSERR    ۾郎ȯ
 ********************************************************************/
function get_collection_principals($resource, $filter, $attrs, &$colledata)
{
    global $calendar_conf;
    global $dg_ldapid;
    global $dg_log_msg;

    /* ١DN */
    $basedn = sprintf("%s=%s,%s",
                      CALRESOURCE, LDAP_dn_escape($resource),
                      $calendar_conf["ldapbasedn"]);

    /*  */
    $type = TYPE_ONELEVEL;

    $ret = DgLDAP_get_entry_batch($basedn, $dg_ldapid, $filter, $attrs,
                                  $type, $colledata);
    if ($ret == LDAP_ERR_NODATA) {
        return FUNC_FALSE;
    } elseif ($ret != LDAP_OK) {
        return FUNC_SYSERR;
    }

    return FUNC_TRUE;
}

/*********************************************************************
 * get_article_data()
 *
 * authorityArticleͤ
 *
 * []
 *      $article              authorityArticleƤξ(
 *      $sep_article_data     authorityArticleID˥桼¤줿
 *                            (Ϥ
 *
 * [֤]
 *      TRUE                  
 *      FALUSE                ۾
 **********************************************************************/
function get_article_data($article, &$sep_article_data)
{
    global $dg_log_msg;

    /* authorityArticleĤ뤫 */
    $num = count($article);

    /* authorityArticle򥳥ڤʬ */
    for ($count = 0 ; $num > $count ; $count++) {
        $article_data = explode(":", $article[$count], 2);

        /* $article_data[0]¸ߡͥå */
        $match = preg_match("/^[0-9]+$/", $article_data[0]);
        if ($match != 1) {
            $dg_log_msg = "Article ID is invalid. (" . $article[$count] . ")";
            return FALSE;
        }

        /* $article_data[1]¸߳ǧ */
        if (isset($article_data[1]) === FALSE || $article_data[1] == "") {
            $dg_log_msg = "Article authority or user name is empty. (" .
                          $article[$count] . ")";
            return FALSE;
        }

        /* ¤ɤ߼ꡢɤ߽񤭡ػ߰ʳΤȤ */
        if (check_auth_flag($article_data[1][0]) === FALSE) {
            $dg_log_msg .= "(" . $article[$count] . ")";
            return FALSE;
        }

        /* authorityArticleUå */
        if ($article_data[1][1] != ARTICLE_SEP) {
            $dg_log_msg = "Article form is invalid. (" . $article[$count] . ")";
            return FALSE;
        }

        /* $article_data[1]桼̾ */
        $user = substr($article_data[1], 2);

        /* authorityArticleΥ桼̾å */
        if (check_user_name($user) === FALSE) {
            $dg_log_msg = "Article user form is invalid. (" .
                          $article[$count] . ")";
            return FALSE;
        }

        /* ¸߳ǧ */
        $id = $article_data[0];
        if (isset($sep_article_data[$id]) === TRUE) {
            $dg_log_msg = "Article id is already exists. (" .
                          $article[$count] . ")";
            return FALSE;
        }

        /* ͤ */
        $sep_article_data[$id]["authority"] = $article_data[1][0];
        $sep_article_data[$id]["user"] = $user;
    }

    return TRUE;
}

/*********************************************************************
 * get_order_data()
 *
 * authorityOrderξʬ򤷡
 *
 * []
 *      $order          authorityOrder
 *      $order_list     (Ϥ
 *
 * [֤]
 *      TRUE        
 *      FALUSE      ۾
 **********************************************************************/
function get_order_data($order, &$order_list)
{
    global $dg_log_msg;

    /* authorityOrder򥳥ڤʬ */
    $order_list = explode(":", $order);

    foreach ($order_list as $order_num) {

        /* ID¸ߤȿͥå */
        $match = preg_match("/^[0-9]+$/", $order_num);
        if ($match != 1) {
            $dg_log_msg = "AuthorityOrder has broken.";
            return FALSE;
        }
    }

    /* IDνʣå */
    $uniq_id = array_unique($order_list);
    $same_id = array_diff_assoc($order_list, $uniq_id);
    if (empty($same_id) === FALSE) {
        $dg_log_msg = "AuthorityOrder has broken.";
        return FALSE;
    }

    return TRUE;
}

/*********************************************************************
 * check_authority_data()
 *
 * 쥯󸢸¾ǧ
 *
 * []
 *      $order         桼¤ν
 *      $article       桼¾
 *      $user          桼
 *      $default       ǥեȸ
 *      $authority     
 *
 * [֤]
 *      TRUE        
 *      FALUSE      ۾
 **********************************************************************/
function check_authority_data($order, $article, $user, $default, &$authority)
{
    global $dg_log_msg;
    $authority = "";

    /* authorityOrderͤ */
    if (get_order_data($order, $order_list) === FALSE) {
        return FALSE;
    }

    /* authorityArticleͤ */
    if (get_article_data($article, $sep_article_data) === FALSE) {
        return FALSE;
    }

    /* $order_listͤäƤ뤫 */
    if (empty($order_list) === TRUE) {
        $dg_log_msg = "Order is empty.";
        return FALSE;
    }

    foreach ($order_list as $order_id) {
        /* 桼authorityArticle¸ߤ뤫 */
        if (isset($sep_article_data[$order_id]) &&
            $sep_article_data[$order_id]["user"] == $user) {
            $authority = $sep_article_data[$order_id]["authority"];
            return TRUE;
        }
    }
    /* ¸ߤʤ */
    $authority = $default;

    return TRUE;
}

/*********************************************************************
 * check_auth_flag()
 *
 * ¤ξϰ⤫ǧ
 *
 * []
 *      $authority     
 *
 * [֤]
 *      TRUE        
 *      FALUSE      ۾
 **********************************************************************/
function check_auth_flag($authority)
{
    global $dg_log_msg;

    /* ǧ */
    $checkarray = array(AUTHREADONLY, AUTHREADWRITE, AUTHRESTRICTION);

    /* ³ǧ */
    $ret = array_search($authority, $checkarray);
    if ($ret === FALSE) {
        $dg_log_msg = "Authority value is inaccurate.(authority=" . $authority . ")";
        return FALSE;
    }

    return TRUE;
}

/**********************************************************
 * add_resource()
 *
 * ꥽
 *
 * []
 *      $resource      ꥽̾
 *      $user          桼̾
 *
 * [֤]
 *      TRUE           
 *      FALSE          
 **********************************************************/
function add_resource($resource, $user)
{
    global $calendar_conf;
    global $dg_ldapid;
    global $dg_log_msg;

    /* ɲä꥽DN */
    $dn_r = sprintf("%s=%s,%s",CALRESOURCE, LDAP_dn_escape($resource),
                    $calendar_conf["ldapbasedn"]);

    /* ꥽° */
    $data_r[OBJECTCLASS] = OBJNAME_CALRESOURCE;
    $data_r[COLLECTIONCOUNT] = COLLECTIONCOUNT_DEF;
    $data_r[CALADMINU] = $user;
    $data_r[CALRESOURCE] = $resource;
    $data_r[COLLECTIONNUMMAX] = COLLECTIONNUMMAX_DEF;

    /* ꥽ */
    $ret_r = DgLDAP_add_entry_batch($dn_r, $dg_ldapid, $data_r);
    if ($ret_r != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/**********************************************************
 * add_default_collection()
 *
 * 쥯home
 *
 * []
 *      $resource      ꥽̾
 *      $user          桼̾
 *
 * [֤]
 *      TRUE           
 *      FALSE          
 **********************************************************/
function add_default_collection($resource, $user)
{
    global $calendar_conf;
    global $dg_ldapid;
    global $dg_log_msg;

    /* ɲä륳쥯DN */
    $dn_c = sprintf("%s=%s,%s=%s,%s", CALCOLLECTION, 
	           LDAP_dn_escape($calendar_conf["autocreatecollectionname"]),
                   CALRESOURCE, LDAP_dn_escape($resource), 
                   $calendar_conf["ldapbasedn"]);

    /* authorityArticle */
    $article = sprintf("%s:%s%s%s", ARTICLE_DEF_ID, AUTHREADWRITE,
                       ARTICLE_SEP, $user);

    /* 쥯° */
    $data_c[OBJECTCLASS] = OBJNAME_CALCOLLECTION;
    $data_c[CALACTIVE] = COLLECTION_ACTIVE;
    $data_c[CALAUTHORITYDEF] = CALAUTHORITYDEF_DEF;
    $data_c[CALAUTHORITYORDER] = AUTHREADONLY;
    $data_c[CALAUTHORITYARTICLE] = $article;
    $data_c[CALCTAG] = CALCTAG_DEF;
    $data_c[CALCOLLECTION] = $calendar_conf["autocreatecollectionname"];
    $data_c[COLLECTIONNUMBER] = COLLECTIONNUMBER_DEF;
    $data_c[COLLECTIONDESCRIPTION] = $resource . "_" .
                                     $calendar_conf["autocreatecollectionname"];

    /* 쥯ɲ */
    $ret_c = DgLDAP_add_entry_batch($dn_c, $dg_ldapid, $data_c);
    if ($ret_c != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/**********************************************************
 * del_resource()
 *
 * ꥽
 *
 * []
 *      $resource      ꥽̾
 *
 * [֤]
 *      TRUE           
 *      FALSE          
 **********************************************************/
function del_resource($resource)
{
    global $dg_ldapid;
    global $dg_log_msg;
    global $calendar_conf;

    /* DN */
    $deldn = sprintf("%s=%s,%s", CALRESOURCE, LDAP_dn_escape($resource),
                     $calendar_conf["ldapbasedn"]);

    /* ꥽ */
    $ret = DgLDAP_del_entry_batch($deldn, $dg_ldapid);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}

/**********************************************************
 * create_resource_collection()
 *
 * ꥽쥯ư
 *
 * []
 *      $resource      ꥽̾
 *      $user          桼̾
 *
 * [֤]
 *      TRUE           
 *      RESO_FALSE     ꥽
 *      COLL_FALSE     쥯
 *      DEL_FALSE      ꥽
 **********************************************************/
function create_resource_collection($resource, $user)
{
    global $dg_log_msg;

    /* ꥽ɲ */
    if (add_resource($resource, $user) === FALSE) {
        return RESO_FALSE;
    }

    /* 쥯ɲ */
    if (add_default_collection($resource, $user) === FALSE) {
        /* 쥯ɲüԻΥ顼ݻ */
        $add_collection_log_msg = $dg_log_msg;

        /* ɲä꥽κ */
        if (del_resource($resource) === FALSE) {
            /* ꥽ԻΥ顼ݻ */
            $del_resource_log_msg = $dg_log_msg;
            /* 쥯ȥ꥽Υ碌 */
            $dg_log_msg = $add_collection_log_msg . ", " . $del_resource_log_msg;
            return DEL_FALSE;
        }
        return COLL_FALSE;
    }

    return TRUE;
}

/*********************************************************
 * createReturnCalendarObject()
 *
 * ǡѾ
 *
 * []
 *       $ldapdata    LDAPǡ
 *       $rettype     륿
 *                      RETTYPE_ONE :ĤΤ
 *                      RETTYPE_MANY:ʣ
 * [֤]
 *       $retarray    
 **********************************************************/
function createReturnCalendarObject($ldapdata, $rettype)
{
    $retarray = array();
    $tmparray = array();

    /* LDAPǡʬξ */
    foreach ($ldapdata as $key => $data) {
        $tmparray[$key][CALDAV_ID]               = $key + 1;
        $tmparray[$key][CALDAV_ID_NUM]           = $key + 1;
        $tmparray[$key][CALDAV_CALENDARDATA]     = $data[CALOBJDATA][0];
        $tmparray[$key][CALDAV_CALENDARDATA_NUM] = $data[CALOBJDATA][0];
        $tmparray[$key][CALDAV_URI]              = $data[CALOBJURI][0];
        $tmparray[$key][CALDAV_URI_NUM]          = $data[CALOBJURI][0];
        $tmparray[$key][CALDAV_CALENDARID]       = CALDAV_CALENDARID_DEF;
        $tmparray[$key][CALDAV_CALENDARID_NUM]   = CALDAV_CALENDARID_DEF;
        $tmparray[$key][CALDAV_LASTMODIFIED]     = $data[CALMODTIME][0];
        $tmparray[$key][CALDAV_LASTMODIFIED_NUM] = $data[CALMODTIME][0];
    }

    if ($rettype == RETTYPE_ONE) {
        /* Ĥ(ñξ) */
        $retarray = $tmparray[0];
    } else {
        /* ʣ */
        $retarray = $tmparray;
    }

    return $retarray;
}

/*********************************************************
 * LDAP_dn_escape()
 *
 * DNΥ
 *
 * DN˻ꤵʸ(,+\<>;#/\)򥨥פޤ
 *
 * []
 *      $str   פʸ
 * [֤]
 *      string ׸ʸ
 **********************************************************/
function LDAP_dn_escape($str)
{
    $trans = array("," => "\\,",
                   "+" => "\\+",
                   "\"" => "\\\"",
                   "<" => "\\<",
                   ">" => "\\>",
                   ";" => "\\;",
                   "#" => "\\#",
                   "/" => "\\/",
                   "\\" => "\\\\");

    return strtr($str, $trans);
}
/*********************************************************
 * check_collection_authority
 * 
 * 쥯θ¥å
 *
 * []
 *      $calendarid	ID
 *      $collection	쥯̾(Ϥ)
 *      $authority	¡ʻϤ)
 * [֤]
 *      $ret 		check_authority_data֤
 **********************************************************/
function check_collection_authority($calendarid, &$collection, &$authority)
{
    global $dg_user;
    global $dg_log_msg;
    global $ldap_collection_data;

    foreach($ldap_collection_data as $one_data) {

        /* IDȥ쥯ʥСפ */
        if ($calendarid == $one_data[COLLECTIONNUMBER][0]) {

            /* ¾Ǽ */
            $order      = $one_data[CALAUTHORITYORDER][0];
            $article    = $one_data[CALAUTHORITYARTICLE];
            $def        = $one_data[CALAUTHORITYDEF][0];
            $collection = $one_data[CALCOLLECTION][0];
            break;
        }
    }
    /* 쥯󸢸³ǧ */
    $ret = check_authority_data($order, $article, $dg_user, $def, $authority);

    return $ret;
}

?>
