/*
 * Copyright 2006 Mask@ Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 maskat.soap={};

maskat.soap.wrapMessage = function(xmlMessage,paramNode){
    var prev = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2001/12/soap-envelope\">"+
        " <soap:Body>";
    return prev + xmlMessage + "</soap:Body></soap:Envelope>";
}

/**
 * 受信電文(soapの場合)から、soap bodyのDOMノードを取得
 * 
 * @param teleDOM 受信電文
 * @return bodyの中身ノード
 */
maskat.soap.unwrapDOM = function(teleDOM,resultNode){
    var children = teleDOM.childNodes;
    var hasBody = false;
    for (var i=0;i<children.length;i++){
        if (children[i].nodeName.indexOf("Body")!=-1){
            //SOAP仕様にしたがって、SOAPメッセージには、HeaderとBody二つ子要素しかないので、
            //nodeNameに「Body」があれば、Body要素であるはず。
            hasBody=true;
            if (children[i].childNodes.length==0){
                throw new MaskatError({name: "Received Tele Error",
                               message: "受信SOAPメッセージのBody要素には子要素がありません。",
                               fileName: "soap.js",
                               functionName: "maskat.soap.unwrapDOM"});
            }
            return children[i].childNodes[0];
        }
    }
    if (!hasBody){
        throw new MaskatError({name: "Received Tele Error",
                       message: "受信SOAPメッセージのBody要素はありません。",
                       fileName: "soap.js",
                       functionName: "maskat.soap.unwrapDOM"});
    }
}
