/*
 * Copyright 2006 Mask@ Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
  ・クロスブラウザ化を実現する機能を集めたオブジェクト
  ・静的クラス
*/

function CrossBrowser(){
}

// ブラウザを判定し、その結果を内部変数に保存する。
CrossBrowser.init = function(){
  CrossBrowser.isIE = false;
  CrossBrowser.isFF = false;

  if (navigator.appName == "Microsoft Internet Explorer"){
    CrossBrowser.isIE = true;
  }
  else if (navigator.appName == "Netscape"){
    CrossBrowser.isFF = true;
  }
  else {
    alert("お使いのブラウザは動作保障対象外です。本システムは正しく機能しません。");
  }
}

// 入力であるXMLの文字列(srcXML)をDOM化したものを返す
CrossBrowser.XML2DOM = function(srcXML){
  var desDOM;

  if (CrossBrowser.isIE){
    desDOM = new ActiveXObject("MSXML2.DOMDocument");
    desDOM.async = false;
    desDOM.loadXML(srcXML);
  }
  else if (CrossBrowser.isFF){
    desDOM = (new DOMParser()).parseFromString(srcXML, "text/xml");
  }

  return desDOM;
}

// getElementsByTagNameのクロスブラウザ化(IE: 名前空間必要、Firefox: 名前空間不必要)
CrossBrowser.getElementsByTagName = function(srcDOM, tagName){
  if (CrossBrowser.isIE){
    return(srcDOM.getElementsByTagName(srcDOM.documentElement.prefix + ":" + tagName));
  }
  else if (CrossBrowser.isFF){
    return(srcDOM.getElementsByTagName(tagName));
  }
}

// ノード内のコンテンツ文字列を取得
CrossBrowser.getInnerContents = function(srcElm){
  if (CrossBrowser.isIE){
    return(srcElm.xml);
  }
  else if (CrossBrowser.isFF){
    return((new XMLSerializer).serializeToString(srcElm));
  }
}

// このライブラリのロード時にブラウザ判定を行う。
// 下記関数呼び出しは対象とする関数定義よりも後に記述する必要がある。
CrossBrowser.init();


