package net.sourceforge.livepinger.notifier;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.JFrame;

import net.sourceforge.livepinger.dto.Live;
import net.sourceforge.livepinger.manager.Configuration;

public class NotifierFrame extends JFrame implements ActionListener {
	private static final long serialVersionUID = -7325642653455831712L;

	Live live;
	Timer timer;
	
	static int WIDTH = 240;
	static int HEIGHT = 60;
	int index;
	
	public NotifierFrame(int index, Live live) {
		super();
		this.index = index;
		this.live = live;
		initialize();
	}

	private void initialize() {
		NotifierButton button = new NotifierButton(live.toString(), live.getBackgroundImageInstance());
		button.addActionListener(this);
		getContentPane().add(button);
		setUndecorated(true);
		setLocationRelativeTo(null);
		setAlwaysOnTop(true);
		
		Dimension desktopSize = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds(desktopSize.width - WIDTH, desktopSize.height - HEIGHT - index * HEIGHT, WIDTH, HEIGHT);
		setVisible(true);
		
		timer = new Timer();
		timer.schedule(new EndTimerTask(), Configuration.getInstance().getPopupLifeTime() * 1000);
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		Desktop desktop = Desktop.getDesktop();
        try {
			desktop.browse(new URI(live.getUrl()));
		} catch (IOException e) {
			e.printStackTrace();
		} catch (URISyntaxException e) {
			e.printStackTrace();
		}
	}
	
	class EndTimerTask extends TimerTask {

		@Override
		public void run() {
			WindowEvent wev = new WindowEvent(NotifierFrame.this, WindowEvent.WINDOW_CLOSING);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
		}
		
	}
	
}
