package net.sourceforge.livepinger.notifier;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.ImageObserver;

import javax.swing.JButton;
import javax.swing.SwingConstants;

public class NotifierButton extends JButton implements ImageObserver {
	private static final long serialVersionUID = 1598823706206251886L;
	private Image backgroundImage;

	public NotifierButton(String name, Image backgroundImage) {
		super(name);
		this.backgroundImage = backgroundImage;
		
		// wi𓧖ɂĔwi摜pӂ
		setBackground(Color.RED);
		setOpaque(false);
		setFocusPainted(false);
		setMargin(new Insets(10, 10, 10, 30));
		setHorizontalAlignment(SwingConstants.LEFT);
	}

	@Override
	public void paintComponent(Graphics g) {
		g.drawImage(backgroundImage, 0, 0, this);
		super.paintComponent(g);
	}
	
	public boolean imageUpdate(Image img,
            int infoflags,
            int x,
            int y,
            int width,
            int height) {
		repaint();
		return true;
	}
}
