package net.sourceforge.livepinger.manager;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * ݒ
 * @author monolit52
 *
 */
public class ConfigureFrame extends JDialog implements ActionListener {
	private static final long serialVersionUID = 4742786725318643353L;
	
	/** |bvAbv\ */
	JTextField popupLifeTimeTextField;
	public JTextField getPopupLifeTimeTextField() {
		return popupLifeTimeTextField;
	}

	public void setPopupLifeTimeTextField(JTextField popupLifeTimeTextField) {
		this.popupLifeTimeTextField = popupLifeTimeTextField;
	}

	/** Kp{^ */
	JButton commitButton;
	/** LZ{^ */
	JButton cancelButton;

	public ConfigureFrame(Window owner, String title) throws HeadlessException {
		super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
		
		initializeFrame();
		initializeComponent();
		initializeConfiguration();
		
		setVisible(true);
	}

	private void initializeConfiguration() {
		Configuration config = Configuration.getInstance();
		popupLifeTimeTextField.setText(String.valueOf(config.getPopupLifeTime()));
	}

	private void initializeComponent() {
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		
		// |bvAbv\(b)
		JLabel popupLifetimeLable = new JLabel("|bvAbv\");
		popupLifeTimeTextField = new JTextField();
		popupLifeTimeTextField.setColumns(4);
		popupLifeTimeTextField.setHorizontalAlignment(JTextField.RIGHT);
		JLabel popupLifetimePrefixLable = new JLabel("b");
		
		JPanel popupPanel = new JPanel();
		popupPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		popupPanel.add(popupLifetimeLable);
		popupPanel.add(popupLifeTimeTextField);
		popupPanel.add(popupLifetimePrefixLable);
		popupPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 40));
		add(popupPanel);
		
		// R~bgn{^
		commitButton = new JButton("Kp");
		commitButton.setSize(60, 30);
		commitButton.addActionListener(this);
		cancelButton = new JButton("LZ");
		cancelButton.setSize(60, 30);
		cancelButton.addActionListener(this);
		
		JPanel commitPanel = new JPanel();
		commitPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		commitPanel.add(commitButton);
		commitPanel.add(cancelButton);
		commitPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 40));
		add(commitPanel);
	}

	private void initializeFrame() {
		setSize(400, 100);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setResizable(false);
		
		URL url = getClass().getResource("/images/icon.png");
		setIconImage(Toolkit.getDefaultToolkit().createImage(url));
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		if (event.getSource() == commitButton) {
			try {
				Configuration config = Configuration.getInstance();
				config.applyFrame(this);
				ConfigurationFile.save(config);
				dispose();
			} catch (IOException e) {
				// TODO: showError
				dispose();
			} catch (ValidationException e) {
				// TODO: showError
			}
		} else if (event.getSource() == cancelButton) {
			dispose();
		}
	}

}
