package net.sourceforge.livepinger.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ConfigurationFile {
	public static String CONFIGURE_FILENAME = "livepinger.cfg";
	public static String CRLF = System.getProperty("line.separator");

	/**
	 * ݒt@Cɉi
	 * @param frame
	 * @throws IOException
	 */
	public static void save(Configuration config) throws IOException, ValidationException {
		int popupLifeTime = config.getPopupLifeTime();
		
		BufferedWriter out = null;
		try {
			out = new BufferedWriter(new FileWriter(CONFIGURE_FILENAME));
			out.write(String.valueOf(popupLifeTime) + CRLF);
		} finally {
			try {
				if (out != null) out.close();
			} catch (IOException e) {
			}
		}

	}
	
	/**
	 * ݒt@Cǂݍ
	 * @param config
	 * @throws IOException
	 */
	public static void load(Configuration config) throws IOException {
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(CONFIGURE_FILENAME));
			String line = in.readLine();
			try {
				config.setPopupLifeTime(Integer.parseInt(line));
			} catch (NumberFormatException e) {
			}
		} finally {
			try {
				if (in != null) in.close();
			} catch (IOException e) {
			}
		}
	}
	
}
