package net.sourceforge.livepinger.manager;

import java.io.IOException;

public class Configuration {
	
	/** VOgCX^X */
	static Configuration instance;
	/** |bvAbv\ */
	int popupLifeTime = 5;
	
	private Configuration() {
	}
	
	public static synchronized Configuration getInstance() {
		if (instance == null) {
			instance = new Configuration();
			try {
				ConfigurationFile.load(instance);
			} catch (IOException e) {
			}
		}
		return instance;
	}

	public synchronized int getPopupLifeTime() {
		return popupLifeTime;
	}

	public synchronized void setPopupLifeTime(int popupLifeTime) {
		this.popupLifeTime = popupLifeTime;
	}
	
	public synchronized void applyFrame(ConfigureFrame frame) throws ValidationException {
		String popupLifeTimeText = frame.getPopupLifeTimeTextField().getText();
		try {
			int popupLifeTime = Integer.parseInt(popupLifeTimeText);
			if (popupLifeTime <= 0) {
				throw new ValidationException("|bvAbv\Ԃ1ȏ̐l͂ĂB");
			}
			this.popupLifeTime = popupLifeTime;
		} catch (NumberFormatException e) {
			throw new ValidationException("|bvAbv\Ԃ1ȏ̐l͂ĂB");
		}
	}
}
