package net.sourceforge.livepinger.dto;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sourceforge.livepinger.crawler.RequestRunner;
import net.sourceforge.livepinger.crawler.RequestRunner.OnRequestDoneListener;

public class CavetubeLive extends Live implements OnRequestDoneListener {
	public static String SERVICE_NAME = "cavetube";
	public static String BASE_URL = "http://gae.cavelis.net/";
	
	/** ʒm|bvAbv̔wi摜 */
	private static final String BACKGROUND_IMAGE_PATH = "/images/notifier_bg_cavetube.png";
	private static Image backgroundImage = null;
	
	/** zMURLp^[ */
	static Pattern URL_PATTERN = Pattern.compile("http://gae\\.cavelis\\.net/view/[0-9A-F]+");
	static Pattern LIVENAME_PATTERN = Pattern.compile("<title>(.*?) : CaveTube</title>");
	static Pattern IDENTIFIER_PATTERN = Pattern.compile("<a href=\"/user/([^\"]+)\" class=\"author_image\">");
	
	/** y[W擾ʒmXi[ */
	OnResolveLiveDoneListener onResolveLiveDoneListener;

	public CavetubeLive(String url, String identifier, String livename) {
		super(url, identifier, livename);
	}

	@Override
	public String getServiceName() {
		return SERVICE_NAME;
	}
	
	public synchronized Image getBackgroundImageInstance() {
		if (backgroundImage == null) {
			URL url = CavetubeLive.class.getResource(BACKGROUND_IMAGE_PATH); 
			backgroundImage = Toolkit.getDefaultToolkit().getImage(url);
		}
		return backgroundImage;
	}

	/**
	 * zMy[W擾ĕsZbgB
	 * ̃\bh͒ʐM𔭐܂B
	 */
	public void crawlLivepage(OnResolveLiveDoneListener onResolveLiveDoneListener) {
		this.onResolveLiveDoneListener = onResolveLiveDoneListener;
		RequestRunner runner = new RequestRunner(getUrl(), this);
		runner.start();
	}

	@Override
	public void onRequestDone(String data) {
		// zM̎擾
		Matcher livenameMatcher = LIVENAME_PATTERN.matcher(data);
		if (livenameMatcher.find()) {
			setName(livenameMatcher.group(1));
		}
		
		// zMҖ̎擾
		Matcher identifierMatcher = IDENTIFIER_PATTERN.matcher(data);
		if (identifierMatcher.find()) {
			setIdentifier(identifierMatcher.group(1));
		}
		
		if (onResolveLiveDoneListener != null) {
			onResolveLiveDoneListener.onResolveLiveDone(this);
		}
	}

	public static boolean match(String url) {
		return URL_PATTERN.matcher(url).matches();
	}
	
}
