package net.sourceforge.livepinger.crawler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

public class RequestRunner extends Thread {
	/** 擾ΏURL */
	String url;
	/** 擾ʒmXi[ */
	OnRequestDoneListener onRequestDoneListener;
	

	public RequestRunner(String url) {
		this(url, null);
	}
	
	public RequestRunner(String url, OnRequestDoneListener onRequestDoneListener) {
		this.url = url;
		this.onRequestDoneListener = onRequestDoneListener;
	}
	
	@Override
	public void run() {
		try {
			String data = getSimplePage();
			if (onRequestDoneListener != null) {
				onRequestDoneListener.onRequestDone(data);
			}
		} catch (CrawlException e) {
		}
	}

	public String getSimplePage() throws CrawlException {
		// NGXgIuWFNg`
		HttpGet request = new HttpGet(url);
		request.setHeader("User-Agent", Messages.getString("Crawler.user_agent")); //$NON-NLS-1$ //$NON-NLS-2$

		// NGXgM
		HttpEntity entity = null;
		try {
			HttpClient client = new DefaultHttpClient();
			HttpResponse response = client.execute(request);
			entity = response.getEntity();

		} catch (IOException e) {
			throw new CrawlException(e);
		}
		
		// ǂݍ
		// ͎̌lĈUeobt@ɑޔ
		StringBuilder builder = new StringBuilder();
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), Messages.getString("Crawler.livetuve_encode"))); //$NON-NLS-1$
			String line;
			while ((line = reader.readLine()) != null) {
	//			System.out.println(line);
				builder.append(line);
			}
			
		} catch (IOException e) {
			throw new CrawlException(e);
		}
		
		return builder.toString();
	}

	public interface OnRequestDoneListener {
		public void onRequestDone(String data);
	}
}
