package net.sourceforge.livepinger.crawler;

import java.util.Calendar;
import java.util.List;

import net.sourceforge.livepinger.dto.Live;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrawlManager extends Thread {
	private static Log log = LogFactory.getLog(CrawlManager.class);
	
	/** N[JnʒmXi */
	OnCrawlStartListener crawlStartListener;
	/** N[ʒmXi */
	OnCrawlDoneListener crawlDoneListener;

	/** N[OtO */
	boolean runningFlag = false;
	
	/** N[ */
	long nextInterval = 0;
	
	/** N[C^[o(~bj */
	long interval = 5 * 60 * 1000;
	
	
	/** ҋ@̃X[vԁi~b) */
	public static int WAIT_INTERVAL = 100;
	
	public CrawlManager(OnCrawlStartListener crawlStartListener, OnCrawlDoneListener crawlDoneListener) {
		this.crawlStartListener = crawlStartListener;
		this.crawlDoneListener = crawlDoneListener;
	}
	
	@Override
	public void run() {
		
		while (true) {
			
			while (true) {
				try {
					Thread.sleep(WAIT_INTERVAL);
				} catch (InterruptedException e) {
				}

				long now = Calendar.getInstance().getTimeInMillis();
				if (now >= nextInterval && runningFlag) {
					nextInterval = now - (now % interval) + interval;
					log.info("[crawl schedule] now: " + now);
					log.info("[crawl schedule] next interval: " + nextInterval);
					log.info("[crawl schedule] crawl starts: ");
					break;
				}
			}
			
			
			// N[OJn
			if (crawlStartListener != null) {
				crawlStartListener.onCrawlStart();
			}
			Crawler crawler = new Crawler(crawlDoneListener);
			try {
				crawler.run();
			} catch (CrawlException e) {
				
			}
			
		}
		
	}
	
	/**
	 * N[OJni܂
	 */
	public void startCrawl() {
		nextInterval = 0;
		runningFlag = true;
	}

	/**
	 * N[O~i~ł͂Ȃj
	 */
	public void stopCrawl() {
		runningFlag = false;
	}
	
	public interface OnCrawlStartListener {
		public void onCrawlStart();
	}
	
	public interface OnCrawlDoneListener {
		public void onCrawlDone(List<Live> lives);
	}

	/**
	 * N[OԂԂ
	 * @return
	 */
	public boolean isRunning() {
		return runningFlag;
	}
	
}
