/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [macro] */

static
int knh_StringUnit_fcmp__default(StringUnit *b, knh_bytes_t v1, knh_bytes_t v2);

/* ======================================================================== */
/* [structs] */

void
knh_StringUnit_struct_init(Ctx *ctx, knh_StringUnit_struct *b, int init, Object *cs)
{
	b->spec.flag = 0;
	b->spec.cid  = CLASS_newid;
	KNH_INITv(b->spec.urn, TS_EMPTY);
	KNH_INITv(b->spec.tag,  TS_EMPTY);
	KNH_INITv(b->spec.defvalue, TS_EMPTY);
	//
	b->fnew = new_StringX__fast;
	b->fcmp = knh_StringUnit_fcmp__default;
	b->fbconv = NULL;
	KNH_INITv(b->bconv, KNH_NULL);
	b->charlen = 0;
	b->bytelen = 0;
	KNH_INITv(b->pattern, KNH_NULL);
	KNH_INITv(b->vocabDictIdx, KNH_NULL);
}

/* ------------------------------------------------------------------------ */

#define _knh_StringUnit_struct_copy   NULL

/* ------------------------------------------------------------------------ */

#define _knh_StringUnit_struct_compare  NULL

/* ------------------------------------------------------------------------ */

void
knh_StringUnit_struct_traverse(Ctx *ctx, knh_StringUnit_struct *b, knh_ftraverse gc)
{
	gc(ctx, UP(b->spec.urn));
	gc(ctx, UP(b->spec.tag));
	gc(ctx, b->spec.defvalue);

	gc(ctx, UP(b->bconv));
	gc(ctx, UP(b->pattern));
	gc(ctx, UP(b->vocabDictIdx));
}

/* ======================================================================== */
/* [constructors] */

StringUnit *new_StringUnit(Ctx *ctx, knh_flag_t flag, knh_class_t cid, String *tag)
{
	StringUnit* o = (StringUnit*)new_Object_malloc(ctx, FLAG_StringUnit, CLASS_StringUnit, sizeof(knh_StringUnit_struct));
	knh_StringUnit_struct_init(ctx, DP(o), 0, NULL);

	DP(o)->spec.flag = flag;
	DP(o)->spec.cid  = cid;
	KNH_SETv(ctx, DP(o)->spec.tag, tag);
	return o;
}

/* ------------------------------------------------------------------------ */

Object *knh_String_cspec(Ctx *ctx)
{
	return (Object*)new_StringUnit(ctx, 0, CLASS_String, TS_EMPTY);
}

///* ------------------------------------------------------------------------ */
//
//Object *knh_StringX_fdefault(Ctx *ctx, knh_class_t cid)
//{
//	DEBUG_ASSERT_cid(cid);
//	{
//		StringUnit *u = (StringUnit*)knh_tClass[cid].cspec;
//		KNH_ASSERT(IS_StringUnit(u));
//		return DP(u)->spec.defvalue;
//	}
//}

/* ======================================================================== */
/* [methods] */
//
//size_t knh_StringUnit_fbconv__toupper(Ctx *ctx, BytesConv *o, knh_bytes_t t, Bytes *ba)
//{
//	size_t i;
//	for(i = 0; i < t.len; i++) {
//		knh_Bytes_putc(ctx, ba, toupper(t.buf[i]));
//	}
//	return i;
//}
//
///* ------------------------------------------------------------------------ */
//
//size_t knh_StringUnit_fbconv__tolower(Ctx *ctx, BytesConv *o, knh_bytes_t t, Bytes *ba)
//{
//	size_t i;
//	for(i = 0; i < t.len; i++) {
//		knh_Bytes_putc(ctx, ba, tolower(t.buf[i]));
//	}
//	return i;
//}

/* ------------------------------------------------------------------------ */

static
int knh_StringUnit_fcmp__default(StringUnit *o, knh_bytes_t v1, knh_bytes_t v2)
{
	size_t i, max = knh_uint_min(v1.len, v2.len);
	for(i = 0; i < max; i++) {
		int res = v1.buf[i] - v2.buf[i];
		if(res != 0) return res;
	}
	return v1.len - v2.len;
}

/* ======================================================================== */
/* [Dict] */

static
String *knh_StringUnit_fnew__dict(Ctx *ctx, knh_class_t cid, knh_bytes_t t, String *orign)
{
	StringUnit *u = (StringUnit*)knh_tClass[cid].cspec;
	KNH_ASSERT(IS_StringUnit(u));
	knh_index_t n = knh_DictIdx_index(ctx, DP(u)->vocabDictIdx, t);
	if(n == -1) return new_StringX__FormatException(ctx, cid, t, orign);
	return knh_DictIdx_get__fast(DP(u)->vocabDictIdx, n);
}

/* ------------------------------------------------------------------------ */

static
int knh_StringUnit_fcmp__dict(StringUnit *o, knh_bytes_t v1, knh_bytes_t v2)
{
	return knh_DictIdx_index(NULL, DP(o)->vocabDictIdx, v1) - knh_DictIdx_index(NULL, DP(o)->vocabDictIdx, v2);
}

///* ------------------------------------------------------------------------ */
//
//static
//void knh_StringUnit_initDict2(Ctx *ctx, StringUnit *o, ObjectNULL *dict, f_bconv fbconv, f_sunit_new fnew, f_sunit_cmp fcmp)
//{
//	DP(o)->fbconv = fbconv;
//	DP(o)->fnew = (fnew == NULL) ? knh_StringUnit_fnew__dict : fnew;
//	DP(o)->fcmp = (fcmp == NULL) ? knh_StringUnit_fcmp__dict : fcmp;
//
//	if(dict == NULL || IS_NULL(dict)) {
//		KNH_SETv(ctx, DP(o)->vocabDictIdx, new_DictIdx(ctx, 12, 0));
//	}
//	else if(IS_DictIdx(dict)) {
//		KNH_SETv(ctx, DP(o)->vocabDictIdx, dict);
//	}
//	else {
//		TODO();
//		KNH_SETv(ctx, DP(o)->vocabDictIdx, new_DictIdx(ctx, 12, 0));
//	}
//}

/* ------------------------------------------------------------------------ */

KNHAPI(ClassSpec*) new_Vocabulary(Ctx *ctx, char *lang, char *defval, ...)
{
	knh_class_t cid = knh_tClass_newId(ctx);
	StringUnit* o = new_StringUnit(ctx, 0, cid, TS_EMPTY);

	DP(o)->fbconv = NULL;
	DP(o)->fnew = knh_StringUnit_fnew__dict;
	DP(o)->fcmp = knh_StringUnit_fcmp__dict;
	KNH_SETv(ctx, DP(o)->vocabDictIdx, new_DictIdx(ctx, 16, 0));

	char *vocab = NULL;
	va_list args;

	va_start(args , defval);
	while((vocab = va_arg(args, char*)) != NULL) {
		String *s = new_String__T(ctx, vocab);
		knh_DictIdx_add__fast(ctx, DP(o)->vocabDictIdx, s);
		if(knh_String_equals(s, B(defval))) {
			KNH_SETv(ctx, DP(o)->spec.defvalue, s);
		}
		s->h.cid = cid;
	}
	va_end(args);

	return (ClassSpec*)o;
}

/* ------------------------------------------------------------------------ */

static
Object *knh_Mapper_fvocab(Ctx *ctx, Object *o, Mapper *mpr)
{
	String *s = (String*)o;
	StringUnit *u = (StringUnit*)knh_tClass[knh_Object_cid(o)].cspec;
	KNH_ASSERT(IS_StringUnit(u));
	KNH_ASSERT(IS_DictIdx(DP(u)->vocabDictIdx));

	StringUnit *u2 = (StringUnit*)knh_tClass[DP(mpr)->tcid].cspec;
	KNH_ASSERT(IS_StringUnit(u2));
	KNH_ASSERT(IS_DictIdx(DP(u2)->vocabDictIdx));

	size_t n = (size_t)knh_DictIdx_index(ctx, DP(u)->vocabDictIdx, knh_String_tobytes(s));
	KNH_ASSERT(n < knh_DictIdx_size(DP(u2)->vocabDictIdx));
	return UP(knh_DictIdx_get__fast(DP(u2)->vocabDictIdx, n));
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) konoha_addVocabularyMapper(Ctx *ctx, knh_class_t scid, char *text)
{
	DEBUG_ASSERT_cid(scid);
	knh_class_t tcid = knh_tClass_findcid(ctx, B(text));

	if(tcid != CLASS_unknown || knh_tClass[tcid].bcid != tcid) {
//		StringUnit *u = (StringUnit*)knh_tClass[scid].cspec;
//		if(!IS_StringUnit(u) || !IS_DictIdx(DP(u)->vocabDictIdx)) {
//			TODO();
//			return;
//		}
		StringUnit *u2 = (StringUnit*)knh_tClass[tcid].cspec;
		if(!IS_StringUnit(u2) || !IS_DictIdx(DP(u2)->vocabDictIdx)) {
			TODO();
			return;
		}
//		if(knh_DictIdx_size(DP(u)->vocabDictIdx) != knh_DictIdx_size(DP(u2)->vocabDictIdx)) {
//			TODO();
//			return;
//		}
		Mapper *mpr = new_Mapper(ctx, KNH_FLAG_MMF_AFFINE, scid, tcid,
				knh_Mapper_fvocab, (Object*)KNH_NULL);
		if(knh_tClass[scid].cmap == NULL) {
			knh_tClass_t *TC = (knh_tClass_t*)(&knh_tClass[scid]);
			KNH_INITv(TC->cmap, new_ClassMap0(ctx, 4));
		}
		knh_ClassMap_add(ctx, knh_tClass[scid].cmap, mpr);

		mpr = new_Mapper(ctx, KNH_FLAG_MMF_AFFINE, tcid, scid,
				knh_Mapper_fvocab, (Object*)KNH_NULL);
		if(knh_tClass[tcid].cmap == NULL) {
			knh_tClass_t *TC = (knh_tClass_t*)(&knh_tClass[tcid]);
			KNH_INITv(TC->cmap, new_ClassMap0(ctx, 4));
		}
		knh_ClassMap_add(ctx, knh_tClass[tcid].cmap, mpr);
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
