/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.junitservlet.actions;

import ams.com.ams.junitservlet.JUServActionSupport;
import ams.com.ams.junitservlet.TestCaseTester;
import ams.com.ams.junitservlet.bean.JUServTestCase;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.AssertionFailedError;
import junit.framework.Test;

public class ExecuteTestCase
extends JUServActionSupport {
    public void doInit(HttpServletRequest req, HttpServletResponse res) throws Exception {
        ArrayList sel_list = new ArrayList();
        HashSet sel_set = new HashSet();
        String[] tc = req.getParameterValues("testcase");
        if (tc == null) {
            return;
        }
        JUServTestCase test_case = this.getJUServTestCaseFromSession(req);
        int i = 0;
        while (i < tc.length) {
            sel_list.add(test_case.getAllCaseList().get(Integer.parseInt(tc[i])));
            sel_set.add(test_case.getAllCaseList().get(Integer.parseInt(tc[i])));
            ++i;
        }
        test_case.setSelTestCaseList(sel_list);
        test_case.setTestcaseChecks(tc);
        test_case.setSelTestCaseSet(sel_set);
        TestCaseTester tct = new TestCaseTester(test_case);
        tct.start();
        test_case.setTester(tct);
        PrintWriter w = res.getWriter();
        this.outputHeader(res);
        w.println(this.getTestCaseTesterStateHtml(tct));
        this.outputHooter(res);
    }

    public void doReTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        JUServTestCase test_case = this.getJUServTestCaseFromSession(req);
        TestCaseTester tct = new TestCaseTester(test_case);
        tct.start();
        test_case.setTester(tct);
        PrintWriter w = res.getWriter();
        this.outputHeader(res);
        w.println(this.getTestCaseTesterStateHtml(tct));
        this.outputHooter(res);
    }

    private void outputHeader(HttpServletResponse res) throws IOException {
        PrintWriter w = res.getWriter();
        w.print("<PRE>");
        w.println("<h2>Test TestCases</h2>");
        w.println("<INPUT type=submit value=\"ReTest\">");
        w.println("<INPUT type=hidden name=act value=executeTestCase>");
        w.println("<INPUT type=hidden name=cmd value=reTest>");
    }

    private void outputHooter(HttpServletResponse res) throws IOException {
        PrintWriter w = res.getWriter();
        w.print("</PRE>");
    }

    private String getTestCaseTesterStateHtml(TestCaseTester tct) {
        StringBuffer buf = new StringBuffer();
        String[] state = new String[]{"testing", "testing", "finished"};
        buf.append("status    :" + state[tct.getState()] + "<BR>");
        if (tct.isUnperform() || tct.isTesting()) {
            buf.append("now testing. please wait...<BR>");
            buf.append("progress:" + tct.getFinishedTestCaseNum() + "/" + tct.getTestCaseNum());
            buf.append("<script type=\"text/javascript\">\n<!-- \n setTimeout(\" location.href ='?act=executeTestCase&cmd=reload' \", 1000);\n //-->\n</script>");
        } else if (tct.isFinished()) {
            buf.append("<b>result</b>   :");
            if (tct.wasSuccessful()) {
                buf.append("<font color=green>successfull</font><BR>");
            } else {
                buf.append("<font color=red>failure</font><BR>");
            }
            buf.append("TestCase  :" + tct.getTestCaseNum() + "<BR>");
            buf.append("Run       :" + tct.getResultRunNum() + "<BR>");
            buf.append("failure   :" + tct.getResultFailureNum() + "<BR>");
            buf.append("error     :" + tct.getResultErrorNum() + "<BR>");
        }
        buf.append("<hr>");
        buf.append("TestCase result<BR><TABLE>");
        Iterator it = ((AbstractList)tct.getTestCase().getSelTestCaseList()).iterator();
        while (it.hasNext()) {
            Class test_class = (Class)it.next();
            String status = (String)tct.getTestcaseStatusMap().get(test_class);
            String mark = tct.getTestcaseStateMarkHtml(status);
            buf.append("<TR><TD><A href=\"#" + test_class.getName() + "\">" + test_class.getName() + "</A></TD><TD>" + mark + "</TD></TR>");
        }
        buf.append("</TABLE>");
        buf.append("<hr>");
        HashMap emap = tct.getErrorsMap();
        if (emap.size() > 0) {
            buf.append("Fail and Errors<BR>");
            Iterator it2 = emap.keySet().iterator();
            while (it2.hasNext()) {
                Test test = (Test)it2.next();
                ArrayList elist = (ArrayList)emap.get(test);
                buf.append("<A name=\"" + test.getClass().getName() + "\"></A>" + test.getClass().getName() + "&nbsp;" + test.countTestCases() + " runs<BR>");
                buf.append("<font color=red>" + test.toString() + "<BR>");
                Iterator ite = ((AbstractList)elist).iterator();
                while (ite.hasNext()) {
                    int i;
                    int c;
                    Object eo = ite.next();
                    if (eo instanceof Throwable) {
                        Throwable th = (Throwable)eo;
                        buf.append("&nbsp;&nbsp;&nbsp;" + th.getLocalizedMessage() + "<BR>");
                        c = th.getStackTrace().length;
                        i = 0;
                        while (i < c) {
                            buf.append("&nbsp;&nbsp;&nbsp;" + th.getStackTrace()[i].toString() + "<BR>");
                            ++i;
                        }
                        continue;
                    }
                    if (!(eo instanceof AssertionFailedError)) continue;
                    AssertionFailedError af = (AssertionFailedError)eo;
                    buf.append("&nbsp;&nbsp;&nbsp;<b>" + af.getLocalizedMessage() + "<BR>");
                    c = af.getStackTrace().length;
                    i = 0;
                    while (i < c) {
                        buf.append("&nbsp;&nbsp;&nbsp;" + af.getStackTrace()[i].toString() + "<BR>");
                        ++i;
                    }
                    buf.append("</b>");
                }
                buf.append("</font>");
            }
        }
        return buf.toString();
    }

    public void doReload(HttpServletRequest req, HttpServletResponse res) throws Exception {
        JUServTestCase test_case = this.getJUServTestCaseFromSession(req);
        TestCaseTester tct = test_case.getTester();
        PrintWriter w = res.getWriter();
        this.outputHeader(res);
        if (tct == null) {
            System.err.println("TestCaseTester is " + tct);
            w.println("TestCaseTester is null. please reselect TestCase.");
        } else {
            w.println(this.getTestCaseTesterStateHtml(tct));
        }
        this.outputHooter(res);
    }
}

