/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.junitservlet;

import ams.com.ams.junitservlet.bean.JUServTestCase;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestCaseTester
extends Thread
implements Serializable,
TestListener {
    private transient JUServTestCase testCase;
    public static final int ST_UNPERFORM = 0;
    public static final int ST_TESTING = 1;
    public static final int ST_FINISHED = 2;
    public static final String TC_STATUS_UNPERFORM = "0";
    public static final String TC_STATUS_TESTING = "1";
    public static final String TC_STATUS_FINISHED_OK = "2";
    public static final String TC_STATUS_FINISHED_FAIL = "3";
    public static final String TC_STATUS_FINISHED_ERR = "4";
    private int state = 0;
    private transient TestResult result = new TestResult();
    private transient HashMap errorsMap = new HashMap();
    private transient HashSet unfinishTestcaseSet = new HashSet();
    private transient HashMap testcaseStatusMap = new HashMap();
    private transient Test testingTest = null;
    private static final HashMap stateMarkHtml = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        stateMarkHtml.put(TC_STATUS_UNPERFORM, "");
        stateMarkHtml.put(TC_STATUS_TESTING, "<FONT color=blue>&gt;</FONT>");
        stateMarkHtml.put(TC_STATUS_FINISHED_FAIL, "<FONT color=red>x</FONT>");
        stateMarkHtml.put(TC_STATUS_FINISHED_ERR, "<FONT color=red><b>x</b></FONT>");
        stateMarkHtml.put(TC_STATUS_FINISHED_OK, "<FONT color=green>o</FONT>");
    }

    public TestCaseTester(JUServTestCase test_case) {
        this.testCase = test_case;
    }

    public void run() {
        System.out.println("TestCaseTester run");
        this.state = 0;
        TestSuite ts = new TestSuite();
        ts.setName("JUnit Servlet");
        this.errorsMap = new HashMap();
        this.unfinishTestcaseSet = new HashSet();
        Iterator it = ((AbstractList)this.testCase.getSelTestCaseList()).iterator();
        while (it.hasNext()) {
            Class tc_class = (Class)it.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("junit.framework.TestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(tc_class)) continue;
            ts.addTestSuite(tc_class);
            this.unfinishTestcaseSet.add(tc_class);
            this.testcaseStatusMap.put(tc_class, TC_STATUS_UNPERFORM);
        }
        this.result = new TestResult();
        this.result.addListener((TestListener)this);
        this.state = 1;
        ts.run(this.result);
        this.state = 2;
        System.out.println("TestCaseTester end");
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        this.state = i;
    }

    public boolean isTesting() {
        return this.state == 1;
    }

    public int getUnfinishedTestCaseNum() {
        return this.testCase.getSelTestCaseList().size() - this.unfinishTestcaseSet.size();
    }

    public int getTestCaseNum() {
        return this.testCase.getSelTestCaseList().size();
    }

    public boolean isFinished() {
        return this.state == 2;
    }

    public int getResultFailureNum() {
        return this.result.failureCount();
    }

    public int getResultErrorNum() {
        return this.result.errorCount();
    }

    public int getResultRunNum() {
        return this.result.runCount();
    }

    public boolean isUnperform() {
        return this.state == 0;
    }

    public void addError(Test test, Throwable th) {
        if (!this.errorsMap.containsKey(test)) {
            this.errorsMap.put(test, new ArrayList());
        }
        ArrayList error_list = (ArrayList)this.errorsMap.get(test);
        error_list.add(th);
        if (this.testcaseStatusMap.containsKey(test.getClass())) {
            this.testcaseStatusMap.put(test.getClass(), TC_STATUS_FINISHED_ERR);
        }
    }

    public void addFailure(Test test, AssertionFailedError err) {
        if (!this.errorsMap.containsKey(test)) {
            this.errorsMap.put(test, new ArrayList());
        }
        ArrayList error_list = (ArrayList)this.errorsMap.get(test);
        error_list.add(err);
        if (this.testcaseStatusMap.containsKey(test.getClass()) && TC_STATUS_TESTING.equals(this.testcaseStatusMap.get(test.getClass()))) {
            this.testcaseStatusMap.put(test.getClass(), TC_STATUS_FINISHED_FAIL);
        }
    }

    public void endTest(Test test) {
        if (this.unfinishTestcaseSet.contains(test.getClass())) {
            this.unfinishTestcaseSet.remove(test.getClass());
        }
        if (this.testcaseStatusMap.containsKey(test.getClass()) && TC_STATUS_TESTING.equals(this.testcaseStatusMap.get(test.getClass()))) {
            this.testcaseStatusMap.put(test.getClass(), TC_STATUS_FINISHED_OK);
        }
    }

    public void startTest(Test test) {
        if (this.testcaseStatusMap.containsKey(test.getClass())) {
            this.testcaseStatusMap.put(test.getClass(), TC_STATUS_TESTING);
        }
        this.testingTest = test;
    }

    public synchronized boolean wasSuccessful() {
        return this.result.wasSuccessful();
    }

    public int getFinishedTestCaseNum() {
        return this.unfinishTestcaseSet.size() == 0 & this.state == 0 ? 0 : this.getTestCaseNum() - this.unfinishTestcaseSet.size();
    }

    public HashMap getErrorsMap() {
        return this.errorsMap;
    }

    public HashMap getTestcaseStatusMap() {
        return this.testcaseStatusMap;
    }

    public String getTestcaseStateMarkHtml(String status) {
        if (status == null) {
            return "";
        }
        return (String)stateMarkHtml.get(status);
    }

    public JUServTestCase getTestCase() {
        return this.testCase;
    }
}

