/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.interceptor;

import org.jtp.SampleException;
import org.springframework.aop.ThrowsAdvice;


/**
 * 例外用インターセプタクラスです。 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class ExceptionInterceptor implements ThrowsAdvice {

	/**
	 * 一般例外をスローします
	 * @param e 例外
	 * @throws SampleException 一般例外
	 */
    public void afterThrowing(Throwable e) throws SampleException {       
        SampleException exception = new SampleException(e);
        exception.printStackTrace();
        throw exception;
    }
}
