/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/** 
 * サービスクラスを提供するクラスです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public final class ServiceLocator {
	
	/** アプリケーションコンテキスト */
    private static final ApplicationContext _context = new ClassPathXmlApplicationContext("applicationContext.xml");

    /**
     * 指定されたサービスを取得します。
     * @param name サービス名
     * @return サービスオブジェクト
     */
    public static Object getService(String name) {
        return _context.getBean(name);
    }
}
