/*
** Job Arranger for ZABBIX
** Copyright (C) 2012 FitechForce, Inc. All Rights Reserved.
** Copyright (C) 2013 Daiwa Institute of Research Business Innovation Ltd. All Rights Reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

/*
** $Date:: 2016-12-13 17:11:02 +0900 #$
** $Revision: 7100 $
** $Author: sypark@FITECHLABS.CO.JP $
**/

#include "common.h"
#include "log.h"

#if defined(ZABBIX_SERVICE)
#include "service.h"
#elif defined(ZABBIX_DAEMON)
#include "daemon.h"
#endif

#include "jasqlite.h"
#include "jadbmain.h"
#include "jadbbackup.h"

/******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *                                                                            *
 * Purpose:                                                                   *
 *                                                                            *
 * Parameters:                                                                *
 *                                                                            *
 * Return value:                                                              *
 *                                                                            *
 * Comments:                                                                  *
 *                                                                            *
 ******************************************************************************/
ZBX_THREAD_ENTRY(jadbbackup_thread, args)
{
    int local_request_failed = 0;
    struct tm	*tm;
    time_t		now;
    int backup_flag=0;


    assert(args);

    zabbix_log(LOG_LEVEL_INFORMATION,
               "jobarg_agentd #%d started [jadbbackup]",
               ((zbx_thread_args_t *) args)->thread_num);
    zbx_free(args);

    while (ZBX_IS_RUNNING()) {
        zbx_setproctitle("process jadbbackup_thread");
        if(CONFIG_BACKUP_RUN_TIME == 24){
        	if (time(NULL) % (CONFIG_BACKUP_TIME * 3600) == 0) {//org
        		zabbix_log(LOG_LEVEL_DEBUG, "jadbbackup  CONFIG_BACKUP_TIME[%d] time[%d]",CONFIG_BACKUP_TIME,(time(NULL) % (CONFIG_BACKUP_TIME * 3600)));
        		zbx_sleep(10);
        		zabbix_log(LOG_LEVEL_INFORMATION, "jadbbackup  CONFIG_BACKUP_TIME START BACKUP");
        		ja_dbmain_backup();
        		zabbix_log(LOG_LEVEL_DEBUG, "jadbbackup  CONFIG_BACKUP_TIME END BACKUP");
        	}
        }else{
        	time(&now);
        	tm = localtime(&now);
        	if(tm->tm_min == 0  && CONFIG_BACKUP_RUN_TIME == tm->tm_hour && backup_flag == 0 ){
        		zabbix_log(LOG_LEVEL_DEBUG, "jadbbackup CONFIG_BACKUP_RUN_TIME [%d] current H[%d]  backup_flag[%d]",CONFIG_BACKUP_RUN_TIME,tm->tm_hour,backup_flag);
        		backup_flag = 1;
        		zbx_sleep(10);
        		zabbix_log(LOG_LEVEL_INFORMATION, "jadbbackup CONFIG_BACKUP_RUN_TIME START BACKUP");
        		ja_dbmain_backup();
        		zabbix_log(LOG_LEVEL_DEBUG, "jadbbackup CONFIG_BACKUP_RUN_TIME END BACKUP");
        	}else if(backup_flag == 1 && CONFIG_BACKUP_RUN_TIME != tm->tm_hour){
        		backup_flag = 0;
        	}

        }
        zbx_sleep(1);
    }

  error:
    zabbix_log(LOG_LEVEL_INFORMATION, "jobarg_agentd jadbbackup stopped");
    ZBX_DO_EXIT();
    zbx_thread_exit(0);
}
