#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: pool.pm 934 2007-07-29 12:26:09Z hikarin $
#

package Zeromin2::App::pool;

use strict;
use Zeromin::Pool qw();

sub create {
    _task(
        shift, 'can_create_pool',
        'POOLED THREAD',
        'TRIED POOLING THREAD', 'create'
    );
}

sub restore {
    _task(
        shift, 'can_recover_pool',
        'RESTORED POOL',
        'TRIED RESTRORING POOL', 'restore'
    );
}

sub remove {
    _task( shift, 'can_remove_pool', 'REMOVED POOl', 'TRIED REMOVING POOL',
        'remove' );
}

sub auto { _auto( shift, 1 ) }

sub auto_confirm { _auto( shift, 0 ) }

sub auto_form {
    my ($zApp) = @_;
    $zApp->privilege( 'can_create_pool', 1 )
        or return $zApp->return_value(1);
    return $zApp->return_value( 0, [] );
}

sub _auto {
    my ( $zApp, $do ) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( 'can_create_pool', 1 )
        or return $zApp->return_value(1);

    my $iRequest    = $zApp->request();
    my $byDate      = $iRequest->param('byDate');
    my $byPos       = $iRequest->param('byPos');
    my $byRes       = $iRequest->param('byRes');
    my $byWriteable = $iRequest->param('byWriteable');
    my $date        = $iRequest->param_int('date');
    my $pos         = $iRequest->param_int('pos');
    my $res         = $iRequest->param_int('res');
    my $condition   = {
        bydate => ( $byDate ? ( $date * 86400 ) : 0 ),
        bypos  => ( $byPos  ? $pos              : 0 ),
        byres  => ( $byRes  ? $res              : 0 ),
        bywriteable => $byWriteable,
    };

    require Zeromin::Subject;
    my $iBBS     = $zApp->bbs();
    my $zSubject = Zeromin::Subject->new($iBBS);
    $zSubject->load();

    my $result = $zSubject->gets_by_condition($condition);
    my $entries = [];
    for my $subject (@$result) {
        my ( $key, $value ) = @$subject;
        push @$entries,
            {
            key    => $key,
            reason => $value->{reason},
            subject => $zSubject->get_utf8($key)->[0],
            value => $value->{value}
            };
    }

    my $template_key = 'Done_pool_auto_confirm';
    if ($do) {
        require Zeromin::Pool;
        my $zPool = Zeromin::Pool->new( $iBBS, 0 );
        my $dir = $iBBS->get_name();
        for my $subject (@$result) {
            my $key = $subject->[0];
            $zPool->set_key($key);
            $zPool->load();
            if ( $zPool->create($key) ) {
                $zApp->logger( 1, 'CREATED POOL: %s/%s', [ $dir, $key ] );
            }
            else {
                $zApp->logger(
                    0,
                    'TRIED CREATING POOl: %s/%s',
                    [ $dir, $key ]
                );
            }
        }
        $template_key = 'Done_pool_auto';
    }

    $zApp->add_template_param(
        {   ByDate        => $byDate,
            ByPos         => $byPos,
            ByRes         => $byRes,
            ByWriteable   => $byWriteable,
            Date          => $date,
            $template_key => 1,
            Pos           => $pos,
            Res           => $res,
            Threads       => $entries
        }
    );
    return $zApp->return_value( 0, $entries );
}

sub _task {
    my ( $zApp, $priv_meth, $success, $fail, $method ) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( $priv_meth, 1 ) or return $zApp->return_value(1);

    my @param = $zApp->request()->param('thread');
    scalar @param or return $zApp->return_value(2);

    my $zBBS   = $zApp->bbs();
    my $bbs    = $zBBS->get_name();
    my $status = {};
    my $zPool  = Zeromin::Pool->new($zBBS);

    $zPool->load();
    for my $key (@param) {
        $zPool->set_key($key);
        if ( $zPool->$method ) {
            $zApp->logger( 1, ( $success . ': %s/%s' ), [ $bbs, $key ] );
            $status->{$key} = 1;
        }
        else {
            $zApp->logger( 0, ( $fail . ': %s/%s' ), [ $bbs, $key ] );
            $status->{$key} = 0;
        }
    }

    return $zApp->return_value( 0, $status );
}

1;
__END__
