#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: User.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Zeromin::Compat::User;

use strict;

sub update {
    my ( $zUser, $iKernel ) = @_;

    require Unicode::Japanese;
    my $base     = $iKernel->get_config()->get('BBSPath');
    my $encoding = $iKernel->get_encoding(1);
    my $unijp    = Unicode::Japanese->new();

    my $ugroup = $base . '/test/info/group.cgi';
    if ( -r $ugroup ) {
        require Img0ch::BBS;
        local ( $!, *FH );
        open *FH, "<${ugroup}"    ## no critic
            or $iKernel->throw_io_exception($ugroup);
        while ( my $line = <FH> ) {
            chomp $line;
            my ( $name, $bbs_dir, undef, $rt ) = split '<>', $line;
            $zUser->get_group_id($name) and next;

            my $role = {};
            my $bbs_id
                = Img0ch::BBS->new( $iKernel, { bbs => $bbs_dir } )->get_id();
            $rt eq '*' and $rt = join ',', ( 1 .. 81 );
            _ugroup_update_privilege( $role, $rt );
            $zUser->add_group(
                {   bbs       => $bbs_id,
                    name      => $unijp->set( $name, 'sjis' )->get(),
                    privilege => {
                        user     => $role->{user},
                        cap      => $role->{cap},
                        bbs      => $role->{bbs},
                        thread   => $role->{thread},
                        res      => $role->{res},
                        pool     => $role->{pool},
                        archive  => $role->{archive},
                        setting  => $role->{setting},
                        meta     => $role->{meta},
                        subject  => $role->{subject},
                        control  => $role->{control},
                        category => $role->{category},
                        view     => $role->{view},
                        plugin   => $role->{plugin},
                    },
                    role => ( $name eq 'Administrators' ? 2 : 1 ),
                }
            );
        }
        close *FH or $iKernel->throw_io_exception($ugroup);
    }

    my $user = $base . '/test/info/users.cgi';
    if ( -r $user ) {
        local ( $!, *FH );
        open *FH, "<${user}"    ## no critic
            or $iKernel->throw_io_exception($user);
        while ( my $line = <FH> ) {
            chomp $line;
            my ( $uname, $pass, $gname, undef ) = split '<>', $line;
            $gname = $unijp->set($gname)->get();
            $zUser->add(
                {   name => $unijp->set( $uname, 'sjis' )->get(),
                    mail => 'dev@slash.null',
                    pass => $pass,
                    gid  => $zUser->get_group_id($gname)
                }
            );
        }
        close *FH or $iKernel->throw_io_exception($ugroup);
    }

    $zUser->save();
    return 1;
}

sub _ugroup_update_privilege {
    my ( $role, $rt ) = @_;
    my $auth = {};
    my @r = index( $rt, ',' ) >= 0 ? split( ',', $rt ) : ($rt);
    map { $auth->{$_} = 1 } @r;
    $role->{user} = 0;
    exists $auth->{9}  and $role->{user} += 1;
    exists $auth->{11} and $role->{user} += 2;
    exists $auth->{12} and $role->{user} += 4;
    exists $auth->{3}  and $role->{user} += 8;
    exists $auth->{5}  and $role->{user} += 16;
    exists $auth->{6}  and $role->{user} += 32;
    $role->{cap} = 0;
    exists $auth->{21} and $role->{cap} += 1;
    exists $auth->{23} and $role->{cap} += 2;
    exists $auth->{24} and $role->{cap} += 4;
    exists $auth->{15} and $role->{cap} += 8;
    exists $auth->{17} and $role->{cap} += 16;
    exists $auth->{18} and $role->{cap} += 32;
    $role->{bbs} = 0;
    exists $auth->{27} and $role->{bbs} += 1;
    exists $auth->{55} and $role->{bbs} += 2;
    exists $auth->{32} and $role->{bbs} += 4;
    exists $auth->{57} and $role->{bbs} += 8;
    $role->{setting} = 0;
    exists $auth->{29} and $role->{setting} = 127;
    $role->{thread} = 0;
    exists $auth->{34} and $role->{thread} += 1;
    exists $auth->{79} and $role->{thread} += 2;
    exists $auth->{37} and $role->{thread} += 4;
    exists $auth->{39} and $role->{thread} += 8;
    exists $auth->{40} and $role->{thread} += 16;
    $role->{pool} = 0;
    exists $auth->{35} and $role->{pool} += 1;
    exists $auth->{78} and $role->{pool} += 2;
    exists $auth->{41} and $role->{pool} += 4;
    $role->{res} = 0;
    exists $auth->{48} and $role->{res} += 1;
    exists $auth->{49} and $role->{res} += 2;
    exists $auth->{45} and $role->{res} += 4;
    $role->{archive} = 0;
    exists $auth->{51} and $role->{archive} += 1;
    exists $auth->{58} and $role->{archive} += 2;
    exists $auth->{53} and $role->{archive} += 4;
    $role->{subject} = 0;
    exists $auth->{56} and $role->{subject} += 1;
    exists $auth->{57} and $role->{subject} += 2;
    $role->{meta} = 0;
    exists $auth->{62} and $role->{meta} += 1;
    exists $auth->{66} and $role->{meta} += 2;
    exists $auth->{64} and $role->{meta} += 4;
    exists $auth->{68} and $role->{meta} += 8;
    $role->{view} = 0;
    exists $auth->{74} and $role->{view} += 1;
    exists $auth->{75} and $role->{view} += 2;
    exists $auth->{80} and $role->{view} += 4;
    $role->{plugin} = 0;
    ( exists $auth->{27} and $auth->{32} ) and $role->{plugin} += 7;
    $role->{category} = 0;
    exists $auth->{81} and $role->{category} += 7;
    $role->{control} = 0;
    exists $auth->{70} and $role->{control} += 28;
    exists $auth->{72} and $role->{control} += 3;
    return;
}

1;
__END__
