#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Cap.pm 492 2007-04-16 14:21:38Z hikarin $
#

package Img0ch::Compat::Cap;

use strict;

sub update {
    my ($iBBS) = @_;

    require Zeromin::Cap;
    require Unicode::Japanese;
    my $iKernel  = $iBBS->get_kernel();
    my $zCap     = Zeromin::Cap->new($iBBS);
    my $base     = $iKernel->get_config()->get('BBSPath');
    my $encoding = $iKernel->get_encoding(1);
    my $unijp    = Unicode::Japanese->new();

    my $cgroup = $base . '/test/info/groupc.cgi';
    if ( -r $cgroup ) {
        require Img0ch::BBS;
        local ( $!, *FH );
        open *FH, "<${cgroup}"    ## no critic
            or $iKernel->throw_io_exception($cgroup);
        while ( my $line = <FH> ) {
            chomp $line;
            my ( $name, $bbs_dir, undef, $rt ) = split '<>', $line;
            $zCap->get_group_id($name) and next;

            my $privilege = 0;
            my $bbs_id
                = Img0ch::BBS->new( $iKernel, { bbs => $bbs_dir } )->get_id();
            _cgroup_update_privilege( \$privilege, $rt );
            $zCap->add_group(
                {   bbs       => $bbs_id,
                    name      => $unijp->set( $name, 'sjis' )->get(),
                    privilege => $privilege
                }
            );
        }
        close *FH or $iKernel->throw_io_exception($cgroup);
    }

    my $cap = $base . '/test/info/caps.cgi';
    if ( -r $cap ) {
        local ( $!, *FH );
        open *FH, "<${cap}"    ## no critic
            or $iKernel->throw_io_exception($cap);
        while ( my $line = <FH> ) {
            chomp $line;
            my ( undef, $cname, $pass, $gname, undef ) = split '<>', $line;
            $gname = $unijp->set( $gname, 'sjis' )->get();
            $zCap->add(
                {   name => $unijp->set( $cname, 'sjis' )->$encoding,
                    pass => $pass,
                    gid  => $zCap->get_group_id($gname)
                }
            );
        }
        close *FH or $iKernel->throw_io_exception($cap);
    }

    $zCap->save();
    return 1;
}

sub _cgroup_update_privilege {
    my ( $role, $rt ) = @_;
    my $auth = {};
    my @r = index( $rt, ',' ) >= 0 ? split( ',', $rt ) : ($rt);
    map { $auth->{$_} = 1 } @r;
    $$role = 1;
    map { exists $auth->{$_} or $$role = 0 } ( 1 .. 7 );
    $auth->{15} and $$role += 2;
    $auth->{8}  and $$role += 4;
    $auth->{18} and $$role += 8;
    $auth->{10} and $$role += 16;
    $auth->{11} and $$role += 32;
    $auth->{13} and $$role += 64;
    $auth->{13} and $$role += 128;
    $auth->{15} and $$role += 256;
    $auth->{17} and $$role += 512;
    return;
}

1;
__END__
