/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Zeromin.Log.Error
 * $Id: error.js 109 2007-01-20 12:49:14Z hikarin $
 */

if ( typeof Zeromin.Log == "undefined" ) {
    Zeromin.Log = {};
}

Zeromin.Log.Error = function(bbs, key) {
    this.bbsID  = bbs.getID();
    this.bbsDir = bbs.getBBS();
    this.key    = key || 0;
    this.loaded = false;
    this.by     = "today";
}

Zeromin.Log.Error.prototype = {
    "getID": function () { this.bbsID },
    "getBBS": function () { this.bbsDir },
    "getCache": function () {},
    "setCache": function (cache) {},
    "setBBS": function (id, bbs) {
        this.key = 0;
        if ( this.bbsDir != bbs ) {
            this.bbsID  = id;
            this.bbsDir = bbs;
        }
        return this;
    },
    "setKey": function (key) {
        if ( this.key != key ) {
            this.key = key;
        }
        return this;
    },
    "setBy": function (by) {
        this.by = by;
        return this;
    },
    "load": function (entriesByPage) {
        var self = this;
        Zeromin.getIO().load(
            [
                { "name" : "C",    "value": "log"      },
                { "name" : "M",    "value": "load"     },
                { "name" : "type", "value": "error"    },
                { "name" : "bbs",  "value": this.bbsID },
                { "name" : "key",  "value": this.key   },
                { "name" : "by",   "value": this.by    }
            ],
            function (storage) {
                var data = storage.read() || [];
                var root = document.getElementById("logErrorRoot");
                var ls   = $(document.getElementById("logErrorTable")).empty();
                var subj = Zeromin.getSubject();
                $("ul.nav-page", root).remove();
                for ( var i in data ) {
                    var item    = data[i];
                    var tdContent = document.createElement("td");
                    tdContent.appendChild(
                        document.createTextNode(item.error)
                    );
                    var tdIP = document.createElement("td");
                    var ip = item.ip;
                    tdIP.appendChild(document.createTextNode(ip));
                    tdIP.innerHTML = "<a href='javascript:void(0)' "
                        + "onclick='Zeromin.DOM.getRemoteHost"
                        + "(this, event, \"" + ip + "\")'>" + ip + "</a>";
                    var tdDate = document.createElement("td");
                    tdDate.appendChild(
                        document.createTextNode(Zeromin.getDate(item.date))
                    );
                    var tdThread = document.createElement("td");
                    tdThread.appendChild(
                        document.createTextNode(subj.get(item.key).subject)
                    );
                    var trBase = document.createElement("tr");
                    trBase.appendChild(tdContent);
                    trBase.appendChild(tdIP);
                    trBase.appendChild(tdDate);
                    trBase.appendChild(tdThread);
                    ls.append(trBase);
                    self.loaded = true;
                }
                Zeromin.DOM.makePager(ls.parent(),
                    (Zeromin.intval(entriesByPage) || 15));
                if ( self.key ) {
                    Zeromin.DOM.toggleMenu("thread");
                    Zeromin.DOM.renderLeftMenu("leftThreadMenu");
                }
                else {
                    Zeromin.DOM.toggleMenu("bbs");
                    Zeromin.DOM.renderLeftMenu("leftBBSLogMenu");
                }
                Zeromin.DOM.setFunction(
                    "Log - Error - " + Zeromin.getBBS().getName()
                );
                Zeromin.DOM.statusOK("エラーログ一覧を表示しました", 1000);
                $(".Container", document).hide();
                $(root).show();
            },
            this
        );
    },
    "render": function() {
    },
    "toString": function() { return this.getBBS() }
};
