/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Zeromin.System
 * $Id: system.js 133 2007-01-25 14:02:41Z hikarin $
 */

Zeromin.System = function() {
    var loadEnvironmentInfo = function() {
        Zeromin.getIO().load(
            [
                { "name": "C", "value": "system" },
                { "name": "M", "value": "environment" }
            ],
            function (storage) {
                var data = storage.get("content") || {};
                var root = document.getElementById("systemEnvironmentRoot");
                for ( var i in data ) {
                    var domName = "env" + i;
                    var domValue = document.getElementById(domName);
                    if (domValue) $(domValue).html(data[i]);
                }
                Zeromin.DOM.toggleMenu("global");
                Zeromin.DOM.renderLeftMenu("leftSystemMenu");
                Zeromin.DOM.setFunction("System - Environment");
                Zeromin.DOM.statusOK("システム情報を表示しました", 1000);
                $(".Container", document).hide();
                $(root).show();
            },
            null
        );
    };
    this.load = loadEnvironmentInfo;
    this.loadEnvironmentInfo = loadEnvironmentInfo;
}

Zeromin.System.prototype = {
    "loadRepositoryInfo": function() {
        var root = document.getElementById("systemRepositoryRoot");
        Zeromin.DOM.toggleMenu("global");
        Zeromin.DOM.renderLeftMenu("leftSystemMenu");
        Zeromin.DOM.setFunction("System - Repository");
        $(".Container", document).hide();
        $(root).show();
    },
    "loadMigrationInfo": function() {
        var root = document.getElementById("systemMigrateRoot");
        Zeromin.DOM.toggleMenu("global");
        Zeromin.DOM.renderLeftMenu("leftSystemMenu");
        Zeromin.DOM.setFunction("System - Migration");
        $(".Container", document).hide();
        $(root).show();
    },
    "makeRepositorySnapshot": function() {
        var zip = document.getElementById(
            "repositorySnapshotWithZip").checked ? 1 : 0;
        Zeromin.getIO().load(
            [
                { "name": "C",   "value": "system" },
                { "name": "M",   "value": "repository" },
                { "name": "zip", "value": zip }
            ],
            function (storage) {
                var data = storage.get();
                storage.writeStatus("レポジトリのバックアップ(スナップショット)を作成しました");
            },
            null
        );
    },
    "refresh": function() {
        Zeromin.getIO().load(
            [
                { "name": "C", "value": "system" },
                { "name": "M", "value": "reload" }
            ],
            function (storage) {
                var data = storage.get();
                storage.writeStatus("モジュールを全て再度読み込みしました");
            },
            null
        );
    },
    "removeTemplateCache": function() {
        Zeromin.getIO().load(
            [
                { "name": "C", "value": "system" },
                { "name": "M", "value": "remove_template_cache" }
            ],
            function (storage) {
                var data = storage.get();
                storage.writeStatus("テンプレートキャッシュを全て削除しました");
            },
            null
        );
    },
    "startMigration": function() {
        var failed = false;
        $("div#migrateSelect input").each(function(){
            if ( this.type.toLowerCase() == "checkbox" && this.checked ) {
                Zeromin.getIO().load(
                    [
                        { "name": "C", "value": "migrate" },
                        { "name": "M", "value": this.name }
                    ],
                    function(storage) {
                        failed = !storage.isReturnedSuccess();
                    },
                    null
                );
            }
        });
        if (!failed) Zeromin.DOM.statusOK("選択されたデータの移行が完了しました。");
    }
};
