/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Template.Type
 * $Id: type.js 749 2007-06-01 13:54:14Z hikarin $
 *
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};
if ( typeof Img0ch.Template == "undefined" ) Img0ch.Template = {};

Img0ch.Template.Type = (function(){
    return {
    "switchCSSTheme": function(theme) {
        var cssTheme = jQuery.grep(
            jQuery("link[@rel='stylesheet']").get(),
            function(i){ return (/\/tdiary\/\w+\/\w+.css$/).test(i.href) });
        jQuery(cssTheme).attr({ "disabled": true });
        var newTheme = document.createElement("link");
        newTheme.href = "../static/tdiary/" + theme + "/" + theme + ".css";
        newTheme.rel = "stylesheet";
        jQuery("head").append(newTheme);
    },
    "renderRes": function( parentObject, root, resno, res ) {
        var divSection       = document.createElement("div");
        divSection.className = "section";
        divSection.id        = "r_" + resno;
        var divCaption       = document.createElement("div");
        divCaption.className = "caption res_header";
        var mail = res[1];
        if (mail) {
            divCaption.innerHTML = String(resno)
                + "&nbsp;名前：<span class=\"commentator\"><a href=\"mailto:"
                + mail + "\"><b>" + res[0] + "</b></a></span>："
                + "<span class=\"commenttime\">" + res[2] + "</span>";
        }
        else {
            divCaption.innerHTML = String(resno)
                + "&nbsp;名前：<span class=\"commentator\">"
                + "<span class=\"nomail\"><b>" + res[0]
                + "</b></span></span>：<span class=\"commenttime\">"
                + res[2] + "</span>";
        }
        var pResBody  = document.createElement("p");
        pResBody.className = "res_body";
        pResBody.innerHTML =
            parentObject.rewrite( resno, String(res[3]) ) + "<br /><br />";
        divSection.appendChild(divCaption);
        divSection.appendChild(pResBody);
        root.appendChild(divSection);
    }
    }
})();
