/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.view.action;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.notify.dialog.NotifyTypeDialog;
import com.clustercontrol.notify.view.NotifyListView;
import com.clustercontrol.util.EndpointManager;

/**
 * 通知[一覧]ビューの作成アクションクラス<BR>
 *
 * @version 5.0.0
 * @since 4.0.0
 */
public class NotifyAddAction extends AbstractHandler {

	/** アクションID */
	public static final String ID = NotifyAddAction.class.getName();

	/** ビュー */
	private IWorkbenchPart viewPart;

	/**
	 * Dispose
	 */
	@Override
	public void dispose() {
		this.viewPart = null;
	}

	/**
	 * 通知種別一覧ダイアログを表示します
	 */
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		// 選択アイテムの取得
		this.viewPart = HandlerUtil.getActivePart(event);
		Object view = this.viewPart.getAdapter(NotifyListView.class);
		if( view instanceof NotifyListView ){
			String managerName = EndpointManager.getActiveManagerNameList().get(0);
			new NotifyTypeDialog(this.viewPart.getSite().getShell(), ((NotifyListView)view).getListComposite(), managerName)
				.open();
		}
		return null;
	}
}
