#!/bin/sh


#Copyright (C) 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#ユーザチェック
if [ ! `whoami` = root ]; then
    echo "rootユーザで実行してください。"
    exit
fi

#設定情報読み込み
. ${0%/*}/install.cfg

EXEC_PATH=${0%/*}

echo ""
echo "Hinemos インストールのための初期化をおこないます。"
echo ""


# カーネルリソースの変更
if [ "${CURRENT_SHMMAX}" -lt "${SHMMAX}" ] ;then
    echo "共有メモリセグメントの最大サイズは "\
    `echo $CURRENT_SHMMAX`" です。"
    echo $SHMMAX"(512MB) に変更してもよろしいですか? (Y/N default:Y)"
    read ANS
    ANS=${ANS:-Y}
    case ${ANS} in
        y|Y)
            echo $SHMMAX > /proc/sys/kernel/shmmax
            echo "" >> /etc/sysctl.conf
            echo "#add for Hinemos Manager" >> /etc/sysctl.conf
            echo "kernel.shmmax=${SHMMAX}" >> /etc/sysctl.conf
            ;;
        n|N)
            echo "インストールを中止します。"
            exit 0
            ;;
        *)
            ;;
    esac	
fi

# カーネルリソースの変更
if [ "${CURRENT_SHMALL}" -lt "${SHMALL}" ] ;then
    echo "システム全体の共有メモリの最大サイズは "\
    `echo $CURRENT_SHMALL`" です。"
    echo $SHMALL"(512MB) に変更してもよろしいですか? (Y/N default:Y)"
    read ANS
    ANS=${ANS:-Y}
    case ${ANS} in
        y|Y)
            echo $SHMALL > /proc/sys/kernel/shmall
            echo "" >> /etc/sysctl.conf
            echo "#add for Hinemos Manager" >> /etc/sysctl.conf
            echo "kernel.shmall=${SHMALL}" >> /etc/sysctl.conf
            ;;
        n|N)
            echo "インストールを中止します。"
            exit 0
            ;;
        *)
            ;;
    esac
fi

# Hinemosユーザの作成
grep $HINEMOS_USER:x /etc/passwd && TMP=1
if [  "${TMP}" -a  -d $HINEMOS_HOME ] ; then
    while [ 1 ] ;
      do
      echo "$HINEMOS_HOME は存在します。"
      echo "パーミッションとオーナーを変更しますか? (Y/N default:Y) "
      read ANS
      ANS=${ANS:-Y}
      case ${ANS} in 
	  y|Y)	
	      chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME 
	      chmod 700 $HINEMOS_HOME
	      echo "パーミッションとオーナーを変更しました。"
	      break
	      ;;
	  n|N)
	      echo "ユーザ hinemos が $HINEMOS_HOME に書き込み可能か確認して下さい。"
	      echo "書き込み不可の場合にはインストールに失敗します。"
	      break
	      ;;
	  *)	
	      ;;
      esac
    done
elif [ -d $HINEMOS_HOME ]; then
    echo ""
    mv $HINEMOS_HOME /opt/hinemos.org
    echo "ユーザ $HINEMOS_USER を作成します。"
    #/usr/sbin/useradd -d $HINEMOS_HOME  $HINEMOS_USER
    /usr/sbin/useradd $HINEMOS_USER
    /usr/bin/passwd $HINEMOS_USER
    
elif [ "${TMP}" ]; then
    mkdir -p $HINEMOS_HOME
    chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME
    echo "インストールディレクトリを作成しました。"
else
    echo "ユーザ $HINEMOS_USER を作成します。"
    #/usr/sbin/useradd -d $HINEMOS_HOME  $HINEMOS_USER
    /usr/sbin/useradd $HINEMOS_USER
    /usr/bin/passwd $HINEMOS_USER	
fi

echo ""

#/opt/hinemos以下にコピー
echo "必要なファイルのコピーを開始します。"
cp -pr $EXEC_PATH/hinemos /opt
#インストールディレクトリに応じて各ファイルを変更
REPLACE_PATH=`echo $HINEMOS_HOME | sed 's/\//\\\\\//g'`
sed "s/%%hinemos_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/hinemos.cfg > $HINEMOS_HOME/hinemos.cfg
SCRIPTS=`ls $EXEC_PATH/bin`
for CURSCRIPT in $SCRIPTS
do
        sed "s/%%hinemos_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/bin/$CURSCRIPT > $HINEMOS_HOME/bin/$CURSCRIPT
        chmod 700 $HINEMOS_HOME/bin/$CURSCRIPT
done

#ftpサーバのIPアドレス
echo "一括制御で利用するFTPサーバのIPアドレスを入力してください。(default:127.0.0.1)"
read FTP_SERVER
FTP_SERVER=${FTP_SERVER:-"127.0.0.1"}
sed "s/%%hinemos_ftp_host%%/$FTP_SERVER/"  $EXEC_PATH/hinemos/lib/cr/cp.sh > $HINEMOS_HOME/lib/cr/cp.sh
sed "s/%%hinemos_ftp_host%%/$FTP_SERVER/"  $EXEC_PATH/hinemos/lib/cr/rpminstall.sh > $HINEMOS_HOME/lib/cr/rpminstall.sh

chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME


echo "必要なファイルのコピーが終了しました。"
echo ""

echo "JREのインストールをおこないます。"
sleep 2
echo ""
cp ${EXEC_PATH}/jre-1_5_0_09-linux-i586.bin ${HINEMOS_HOME}
CURRENT_DIR=`pwd`
cd ${HINEMOS_HOME}
${HINEMOS_HOME}/jre-1_5_0_09-linux-i586.bin
rm ${HINEMOS_HOME}/jre-1_5_0_09-linux-i586.bin
cd $CURRENT_DIR


#syslog-ngインストール
echo "syslog-ngのインストールを行います。"
    chmod 766 /dev/log

    # rpmインストール
    rpm -Uvh --force $SYSLOG_NG_RPM
                                                                                
    # syslog-ng の編集
    if [ 0 -eq `grep -i hinemos /etc/syslog-ng/syslog-ng.conf 2> /dev/null | wc -l` ] ; then
        sed -e "s%__HINEMOS_HOME__%$HINEMOS_HOME%g" -e "s%__JRE__%$JRE_NAME%g" ./hinemos.conf >> /etc/syslog-ng/syslog-ng.conf
    fi
                                                                              
    # syslog-ng の再起動
    /etc/init.d/syslog stop
    /etc/init.d/syslog-ng start
    /sbin/chkconfig --level 2345 syslog off
    /sbin/chkconfig --level 2345 syslog-ng on

#DB初期化
echo "データベースの初期化を行ないます。"

cd ${HINEMOS_HOME}
su -c ${HINEMOS_HOME}/sbin/db_init/pg_init.sh $HINEMOS_USER
