#!/bin/sh


#Copyright (C) 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#ユーザチェック
if [ ! `whoami` = root ]; then
    echo "Please execute by a root user."
    exit
fi

#設定情報読み込み
. ${0%/*}/install.cfg

EXEC_PATH=${0%/*}

echo ""
echo "Initialization for Hinemos installation will be started."
echo ""

# カーネルリソースの変更
if [ "${CURRENT_SHMMAX}" -lt "${SHMMAX}" ] ;then
    echo "Current SHMMAX size is "\
    `echo $CURRENT_SHMMAX`"."
    echo " May I change SHMMAX size $SHMMAX (512MB) ? (Y/N default:Y)"
    read ANS
    ANS=${ANS:-Y}
    case ${ANS} in
        y|Y)
            echo $SHMMAX > /proc/sys/kernel/shmmax
            echo "" >> /etc/sysctl.conf
            echo "#add for Hinemos Manager" >> /etc/sysctl.conf
            echo "kernel.shmmax=${SHMMAX}" >> /etc/sysctl.conf
            ;;
        n|N)
            echo "Exit Installer"
            exit 0
            ;;
        *)
            ;;
    esac
fi

# カーネルリソースの変更
if [ "${CURRENT_SHMALL}" -lt "${SHMALL}" ] ;then
    echo " Current SHMALL size is "\
    `echo $CURRENT_SHMALL`"."
    echo "May I change SHMALL size $SHMALL (512MB) ? (Y/N default:Y)"
    read ANS
    ANS=${ANS:-Y}
    case ${ANS} in
        y|Y)
            echo $SHMALL > /proc/sys/kernel/shmall
            echo "" >> /etc/sysctl.conf
            echo "#add for Hinemos Manager" >> /etc/sysctl.conf
            echo "kernel.shmall=${SHMALL}" >> /etc/sysctl.conf
            ;;
        n|N)
            echo "Exit Installer."
            exit 0
            ;;
        *)
            ;;
    esac
fi




grep $HINEMOS_USER:x /etc/passwd && TMP=1

if [  "${TMP}" -a  -d $HINEMOS_HOME ] ; then
    while [ 1 ] ;
      do
      echo "$HINEMOS_HOME exists."
      echo "Do you change the access permission and the owner?(Y/N default:Y) "
      read ANS
      ANS=${ANS:-Y}
      case ${ANS} in 
	  y|Y)	
	      chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME 
	      chmod 700 $HINEMOS_HOME
	      echo "The access permission and the owner were changed."
	      break
	      ;;
	  n|N)
	      echo "Make sure that user hinemos enables to write to $HINEMOS_HOME ."
	      echo "Installation will fail when it doesn't have writable authority."
	      break
	      ;;
	  *)	
	      ;;
      esac
    done
elif [ -d $HINEMOS_HOME ]; then
    echo ""
    mv $HINEMOS_HOME /opt/hinemos.org
    echo "Create user $HINEMOS_USER ."
    #/usr/sbin/useradd -d $HINEMOS_HOME  $HINEMOS_USER
    /usr/sbin/useradd $HINEMOS_USER
    /usr/bin/passwd $HINEMOS_USER
    
elif [ "${TMP}" ]; then
    mkdir -p $HINEMOS_HOME
    chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME
    echo "The installation Directory was created."
else
    echo "Create user $HINEMOS_USER ."
    #/usr/sbin/useradd -d $HINEMOS_HOME  $HINEMOS_USER
    /usr/sbin/useradd $HINEMOS_USER
    /usr/bin/passwd $HINEMOS_USER	
fi


#/opt/hinemos以下にコピー
echo "Start copying required files."
cp -pr $EXEC_PATH/hinemos /opt
#インストールディレクトリに応じて各ファイルを変更
REPLACE_PATH=`echo $HINEMOS_HOME | sed 's/\//\\\\\//g'`
sed "s/%%hinemos_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/hinemos.cfg > $HINEMOS_HOME/hinemos.cfg
SCRIPTS=`ls $EXEC_PATH/bin`
for CURSCRIPT in $SCRIPTS
do
	sed "s/%%hinemos_install_dir%%/$REPLACE_PATH/" $EXEC_PATH/bin/$CURSCRIPT > $HINEMOS_HOME/bin/$CURSCRIPT
	chmod 700 $HINEMOS_HOME/bin/$CURSCRIPT
done

#ftpサーバのIPアドレス
echo "Plese input ftp server's IP address  for corrective run (default:127.0.0.1)"
read FTP_SERVER
FTP_SERVER=${FTP_SERVER:-"127.0.0.1"}
sed "s/%%hinemos_ftp_host%%/$FTP_SERVER/"  $EXEC_PATH/hinemos/lib/cr/cp.sh > $HINEMOS_HOME/lib/cr/cp.sh
sed "s/%%hinemos_ftp_host%%/$FTP_SERVER/"  $EXEC_PATH/hinemos/lib/cr/rpminstall.sh > $HINEMOS_HOME/lib/cr/rpminstall.sh



chown -R  $HINEMOS_USER:$HINEMOS_USER $HINEMOS_HOME

echo "Copying required files was completed."
echo ""

echo "Installing JRE"
sleep 2
echo ""
cp ${EXEC_PATH}/jre-1_5_0_09-linux-i586.bin ${HINEMOS_HOME}
CURRENT_DIR=`pwd`
cd ${HINEMOS_HOME}
${HINEMOS_HOME}/jre-1_5_0_09-linux-i586.bin
rm ${HINEMOS_HOME}/jre-1_5_0_09-linux-i586.bin
cd $CURRENT_DIR


#syyslog-ngインストール
  echo "Start the installation of syslog-ng."
	chmod 766 /dev/log

        # rpmインストール
        rpm -Uvh --force $SYSLOG_NG_RPM
                                                                                
        # syslog-ng の編集
        if [ 0 -eq `grep -i hinemos /etc/syslog-ng/syslog-ng.conf 2> /dev/null | wc -l` ] ; then
            sed -e "s%__HINEMOS_HOME__%$HINEMOS_HOME%g" -e "s%__JRE__%$JRE_NAME%g" ./hinemos.conf >> /etc/syslog-ng/syslog-ng.conf
        fi
                                                                                
        # syslog-ng の再起動
        /etc/init.d/syslog stop
        /etc/init.d/syslog-ng start
        /sbin/chkconfig --level 2345 syslog off
        /sbin/chkconfig --level 2345 syslog-ng on

#DB初期化
echo "データベースの初期化を行ないます。"

cd ${HINEMOS_HOME}
su -c ${HINEMOS_HOME}/sbin/db_init/pg_init.sh $HINEMOS_USER
