#!/bin/bash

#Copyright (C) 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#
# 変数
#

. /opt/hinemos/hinemos.cfg

DBUSER=hinemos
DBNAME=hinemos
DBPORT=24001
#DBPORT=5432
DBHOST=localhost

OPTION=""
REV=0

#
# パラメタに応じて処理
#

if [ $# -ne 0 ]; then
	if [  "$#" -ne "1" -o  "$1" != "-F"  ]; then
		echo "使用方法"
		echo "hinemos_mng_vacuum.sh    : 通常のvacuumを実行します。"
		echo "hinemos_mng_vacuum.sh -F : full vacuumを実行します。"
		exit 1
	else
		echo "full vacuumを実行します。"
		OPTION="-f"
	fi
else
	echo "通常のvacuumを実行します。"
	OPTION=""
fi
vacuumdb -p $DBPORT -h $DBHOST -U $DBUSER -z $OPTION -d $DBNAME

#
# 終了処理
#

if [ $? -ne 0 ]; then 
	echo "処理に失敗しました。"
	exit 1 
fi
echo "正常に終了しました。"
exit 0

