#!/bin/bash

#Copyright (C) 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#
# 変数
#

. /opt/hinemos/hinemos.cfg

DBUSER=hinemos
DBNAME=hinemos
DBPORT=24001
#DBPORT=5432
DBHOST=localhost
SQLPATH=/opt/hinemos/sbin/mng/sql
SQL=""

REV=0

MESSAGE1="確認済みのイベントをDBから削除します。"
MESSAGE2="すべてのイベントをDBから削除します。"
MESSAGE3="完了したジョブ実行履歴をDBから削除します。" 	
MESSAGE4="すべてのジョブ実行履歴をDBから削除します。"
MESSAGE5="完了した一括制御実行履歴をDBから削除します。"
MESSAGE6="すべての一括制御実行履歴をDBから削除します。"

#
# function
#
function usage {
	echo "使用方法"
	echo "hinemos_mng_delete.sh -e : "$MESSAGE1
	echo "hinemos_mng_delete.sh -E : "$MESSAGE2
	echo "hinemos_mng_delete.sh -j : "$MESSAGE3
	echo "hinemos_mng_delete.sh -J : "$MESSAGE4
	echo "hinemos_mng_delete.sh -c : "$MESSAGE5
	echo "hinemos_mng_delete.sh -C : "$MESSAGE6
	return 0
}

#
# パラメタチェック
#

if [ $# -eq 0 ]; then 
	usage
	exit 1
fi

for OPTION in "$@"
do 
	case $OPTION in 
		-e|-E|-j|-J|-c|-C)
			;;
		*)
			usage
			exit 1
			;;
	esac
done

#
# パラメタに応じて処理
#
			
for OPTION in "$@"
do
	case $OPTION in
		-e)
			echo $MESSAGE1
			SQL=$SQLPATH/delete_event.sql
			;;
		-E)
			echo $MESSAGE2
			SQL=$SQLPATH/delete_event_all.sql
			;;
		-j)	
			echo $MESSAGE3 	
			SQL=$SQLPATH/delete_job_history.sql
			;;
		-J)
			echo $MESSAGE4
			SQL=$SQLPATH/delete_job_history_all.sql
			;;
		-c)
			echo $MESSAGE5
			SQL=$SQLPATH/delete_crun_history.sql
			;;
		-C)
			echo $MESSAGE6
			SQL=$SQLPATH/delete_crun_history_all.sql
			;;
		*)
			exit 1
			;;
	esac

	psql -p $DBPORT -h $DBHOST -U $DBUSER -d $DBNAME -f $SQL
	if [ $? -ne 0 ]; then
		REV=$?
		echo "処理に失敗しました。"
		exit $REV
	fi
done

#
# 終了処理
#

echo "正常に終了しました。"

exit 0 

