#!/bin/sh
MKDIR_PROC="/bin/mkdir"
CHOWN_PROC="/bin/chown"

##
## Ǽ
##
while [ $# -gt 0 ]
do
  #echo $1
  case $1 in
    -u)
      shift
      user="$1"
      ;;
    -g)
      shift
      group="$1"
      ;;
    -m)
      shift
      mode="-m $1"
      ;;
    *)
      #ǥ쥯ȥ̾
      dirname=$1
      ;;
  esac

  shift

done

##
##桼ϥå
##
if [ ${#user} -eq 0 ] ; then
    echo 'The user is not specified.' 1>&2
    exit 11
fi

##
##롼ϥå
##
if [ ${#group} -eq 0 ] ; then
    echo 'The group is not specified.' 1>&2
    exit 12
fi

##
## mkdirޥɼ¹
##
echo "$MKDIR_PROC $mode $dirname"
$MKDIR_PROC $mode $dirname
if [ $? -ne 0 ] ; then
    exit 10
fi

##
## chownޥɼ¹
##
if [ ${#user} -ne 0 ] ; then
    ownarg=$user
fi
if [ ${#group} -ne 0 ] ; then
    ownarg=$ownarg:$group
fi
if [ ${#ownarg} -ne 0 ] ; then
    echo "$CHOWN_PROC $ownarg $dirname"
    $CHOWN_PROC $ownarg $dirname
    if [ $? -ne 0 ] ; then
        exit 1
    fi
fi

exit

