/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.packaging.JarVisitor;

public class ZippedJarVisitor
extends JarVisitor {
    private static Log log = LogFactory.getLog(ZippedJarVisitor.class);

    public ZippedJarVisitor(URL url, JarVisitor.Filter[] filters) {
        super(url, filters);
    }

    public ZippedJarVisitor(String fileName, JarVisitor.Filter[] filters) {
        super(fileName, filters);
    }

    protected void doProcessElements() {
        JarFile jarFile;
        try {
            jarFile = new JarFile(this.jarUrl.getFile());
        }
        catch (IOException ze) {
            log.warn((Object)("Unable to find file (ignored): " + this.jarUrl), (Throwable)ze);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            try {
                this.addElement(entry.getName(), jarFile.getInputStream(entry), jarFile.getInputStream(entry));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

