/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.handlers;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class LogHandler
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)LogHandler.class.getName());
    long start = -1L;
    private boolean writeToConsole = false;
    private String filename = "axis.log";

    public void init() {
        super.init();
        Object opt = this.getOption("LogHandler.writeToConsole");
        if (opt != null && opt instanceof String && "true".equalsIgnoreCase((String)opt)) {
            this.writeToConsole = true;
        }
        if ((opt = this.getOption("LogHandler.fileName")) != null && opt instanceof String) {
            this.filename = (String)opt;
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        log.debug((Object)"Enter: LogHandler::invoke");
        if (!msgContext.getPastPivot()) {
            this.start = System.currentTimeMillis();
        } else {
            this.logMessages(msgContext);
        }
        log.debug((Object)"Exit: LogHandler::invoke");
    }

    private void logMessages(MessageContext msgContext) throws AxisFault {
        try {
            PrintWriter writer = null;
            writer = this.getWriter(msgContext);
            Message inMsg = msgContext.getRequestMessage();
            Message outMsg = msgContext.getResponseMessage();
            writer.println("=======================================================");
            if (this.start != -1L) {
                writer.println("= " + Messages.getMessage("elapsed00", "" + (System.currentTimeMillis() - this.start)));
            }
            writer.println("= " + Messages.getMessage("inMsg00", inMsg == null ? "null" : inMsg.getSOAPPartAsString()));
            writer.println("= " + Messages.getMessage("outMsg00", outMsg == null ? "null" : outMsg.getSOAPPartAsString()));
            writer.println("=======================================================");
            if (!this.writeToConsole) {
                writer.close();
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
    }

    private PrintWriter getWriter(MessageContext msgContext) throws IOException {
        PrintWriter writer;
        if (this.writeToConsole) {
            writer = new PrintWriter(System.out);
        } else {
            if (this.filename == null) {
                this.filename = "axis.log";
            }
            writer = new PrintWriter(new FileWriter(this.filename, true));
        }
        return writer;
    }

    public void onFault(MessageContext msgContext) {
        try {
            this.logMessages(msgContext);
        }
        catch (AxisFault axisFault) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)axisFault);
        }
    }
}

