/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.jboss.axis.encoding.Target;
import org.jboss.axis.encoding.ser.BeanDeserializer;
import org.jboss.axis.encoding.ser.DeferredBeanConstruction;
import org.jboss.axis.utils.BeanPropertyDescriptor;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.SAXException;

public class BeanPropertyTarget
implements Target {
    private static Logger log = Logger.getLogger((String)BeanPropertyTarget.class.getName());
    private Object object;
    private BeanPropertyDescriptor pd;
    private int index = -1;
    protected DeferredBeanConstruction deferedConstruction;
    protected BeanDeserializer beanDeserializer;

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor pd) {
        this.object = object;
        this.pd = pd;
        this.index = -1;
    }

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor pd, int i) {
        this.object = object;
        this.pd = pd;
        this.index = i;
    }

    public BeanPropertyTarget(BeanDeserializer beanDeserializer, DeferredBeanConstruction deferedConstruction, BeanPropertyDescriptor pd) {
        this.beanDeserializer = beanDeserializer;
        this.deferedConstruction = deferedConstruction;
        this.pd = pd;
        this.index = -1;
    }

    public void set(Object value) throws SAXException {
        if (this.object == null && this.deferedConstruction == null) {
            throw new IllegalStateException("Target object does not exist");
        }
        if (this.object == null && this.deferedConstruction != null) {
            this.object = this.deferedConstruction.newBeanInstance(value);
            this.beanDeserializer.setValue(this.object);
            return;
        }
        try {
            if (this.index < 0) {
                this.pd.set(this.object, value);
            } else {
                this.pd.set(this.object, this.index, value);
            }
        }
        catch (Exception e) {
            try {
                Class type = this.pd.getType();
                if (JavaUtils.isConvertable(value, type)) {
                    value = JavaUtils.convert(value, type);
                    if (this.index < 0) {
                        try {
                            this.pd.set(this.object, value);
                        }
                        catch (IllegalAccessException e1) {
                            log.warn((Object)("Can not set " + value + " on " + this.object + " as it does not have a setter for this value."));
                        }
                    } else {
                        this.pd.set(this.object, this.index, value);
                    }
                }
                if (this.index == 0 && value.getClass().isArray() && !type.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object item = JavaUtils.convert(Array.get(value, i), type);
                        this.pd.set(this.object, i, item);
                    }
                }
                throw e;
            }
            catch (Exception ex) {
                Throwable t;
                String field = this.pd.getName();
                if (this.index >= 0) {
                    field = field + "[" + this.index + "]";
                }
                String valueType = "null";
                if (value != null) {
                    valueType = value.getClass().getName();
                }
                log.error((Object)Messages.getMessage("cantConvert02", new String[]{valueType, field, this.pd.getType().getName()}));
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) != null) {
                    String classname = this.object.getClass().getName();
                    throw new SAXException(Messages.getMessage("cantConvert04", new String[]{classname, field, value == null ? null : value.toString(), t.getMessage()}));
                }
                throw new SAXException(ex);
            }
        }
    }
}

