/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3JoinColumn
extends Ejb3Column {
    private String propertyName;
    private String referencedColumn;
    private String mappedBy;
    private String defaultColumnHeader;
    private String manyToManyOwnerSideEntityName;
    public static final int NO_REFERENCE = 0;
    public static final int PK_REFERENCE = 1;
    public static final int NON_PK_REFERENCE = 2;

    public String getManyToManyOwnerSideEntityName() {
        return this.manyToManyOwnerSideEntityName;
    }

    public void setManyToManyOwnerSideEntityName(String manyToManyOwnerSideEntityName) {
        this.manyToManyOwnerSideEntityName = manyToManyOwnerSideEntityName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReferencedColumn(String referencedColumn) {
        this.referencedColumn = referencedColumn;
    }

    public void setDefaultColumnHeader(String defaultColumnHeader) {
        this.defaultColumnHeader = defaultColumnHeader;
    }

    public String getDefaultColumnHeader() {
        return this.defaultColumnHeader;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public Ejb3JoinColumn() {
        this.setMappedBy("");
    }

    public Ejb3JoinColumn(String sqlType, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String referencedColumn, String secondaryTable, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, String mappedBy, boolean isImplicit, Mappings mappings) {
        this.setImplicit(isImplicit);
        this.setSqlType(sqlType);
        this.setColumnName(name);
        this.setNullable(nullable);
        this.setUnique(unique);
        this.setInsertable(insertable);
        this.setUpdatable(updatable);
        this.setSecondaryTableName(secondaryTable);
        this.setPropertyHolder(propertyHolder);
        this.setJoins(joins);
        this.setMappings(mappings);
        this.bind();
        this.referencedColumn = referencedColumn;
        this.propertyName = propertyName;
        this.mappedBy = mappedBy;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        if (ann != null) {
            Ejb3JoinColumn joinColumn = new Ejb3JoinColumn();
            joinColumn.setJoinAnnotation(ann, null);
            joinColumn.setJoins(joins);
            joinColumn.setPropertyHolder(propertyHolder);
            joinColumn.setPropertyName(propertyName);
            joinColumn.setImplicit(false);
            joinColumn.setMappings(mappings);
            joinColumn.bind();
            return joinColumn;
        }
        Ejb3JoinColumn joinColumn = new Ejb3JoinColumn();
        joinColumn.setJoins(joins);
        joinColumn.setPropertyHolder(propertyHolder);
        joinColumn.setPropertyName(propertyName);
        joinColumn.setImplicit(true);
        joinColumn.setMappings(mappings);
        joinColumn.bind();
        return joinColumn;
    }

    public void setJoinAnnotation(JoinColumn annJoin, String defaultName) {
        if (annJoin == null) {
            this.setImplicit(true);
        } else {
            this.setImplicit(false);
            if (!AnnotationBinder.isDefault(annJoin.columnDefinition())) {
                this.setSqlType(annJoin.columnDefinition());
            }
            if (!AnnotationBinder.isDefault(annJoin.name())) {
                this.setColumnName(annJoin.name());
            }
            this.setNullable(annJoin.nullable());
            this.setUnique(annJoin.unique());
            this.setInsertable(annJoin.insertable());
            this.setUpdatable(annJoin.updatable());
            this.setReferencedColumn(annJoin.referencedColumnName());
            this.setSecondaryTableName(annJoin.secondaryTable());
        }
    }

    public static Ejb3JoinColumn buildImplicitJoinColumn(String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        return new Ejb3JoinColumn(null, null, true, false, true, true, null, null, joins, propertyHolder, propertyName, mappedBy, true, mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = col.getName();
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), ann.secondaryTable(), joins, propertyHolder, null, null, false, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, true, false, true, true, null, null, joins, propertyHolder, null, null, false, mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(PrimaryKeyJoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = col.getName();
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, false, false, true, true, ann.referencedColumnName(), null, joins, propertyHolder, null, null, false, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, false, false, true, true, null, null, joins, propertyHolder, null, null, true, mappings);
    }

    public void setPersistentClass(PersistentClass persistentClass, Map<String, Join> joins) {
        this.propertyHolder = PropertyHolderBuilder.buildPropertyHolder(persistentClass, joins);
    }

    public static void checkIfJoinColumn(Object columns, PropertyHolder holder, PropertyInferredData property) {
        if (!(columns instanceof Ejb3JoinColumn[])) {
            throw new AnnotationException("@Column cannot be used on an association property: " + holder.getEntityName() + "." + property.getPropertyName());
        }
    }

    public void linkValueUsingDefaultColumnNaming(Column column, SimpleValue value) {
        boolean isAnAssociation;
        boolean bl = isAnAssociation = this.defaultColumnHeader != null || this.propertyName != null;
        String columnName = isAnAssociation ? (this.defaultColumnHeader == null ? this.propertyName : this.defaultColumnHeader) + "_" + column.getName() : column.getName();
        this.initMappingColumn(columnName, column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique());
        this.linkWithValue(value);
    }

    public void linkValueUsingAColumnCopy(Column column, SimpleValue value) {
        this.initMappingColumn(column.getName(), column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique());
        this.linkWithValue(value);
    }

    public static int checkReferencedColumnsType(Ejb3JoinColumn[] columns, PersistentClass referencedEntity) {
        HashSet<Column> idColumns = new HashSet<Column>();
        Iterator idColumnsIt = referencedEntity.getIdentifier().getColumnIterator();
        while (idColumnsIt.hasNext()) {
            idColumns.add((Column)idColumnsIt.next());
        }
        boolean isFkReferencedColumnName = false;
        boolean noReferencedColumn = true;
        for (Ejb3JoinColumn ejb3Column : columns) {
            String referencedColumnName = ejb3Column.getReferencedColumn();
            if (!StringHelper.isNotEmpty((String)referencedColumnName)) continue;
            noReferencedColumn = false;
            Column refCol = new Column(referencedColumnName);
            boolean contains = idColumns.contains(refCol);
            if (contains) continue;
            isFkReferencedColumnName = true;
        }
        if (isFkReferencedColumnName) {
            return 2;
        }
        if (noReferencedColumn) {
            return 0;
        }
        return 1;
    }

    public void overrideSqlTypeIfNecessary(Column column) {
        if (StringHelper.isEmpty((String)this.sqlType)) {
            this.sqlType = column.getSqlType();
            if (this.getMappingColumn() != null) {
                this.getMappingColumn().setSqlType(this.sqlType);
            }
        }
    }
}

