/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import com.clustercontrol.performanceMGR.bean.DeviceData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DeviceDataSet
implements Serializable {
    private HashMap deviceMap = new HashMap();

    public void putDeviceList(DeviceData deviceData) {
        ArrayList<DeviceData> deviceList;
        String facilitID = deviceData.getFacilityId();
        String deviceType = deviceData.getDeviceType();
        HashMap<String, ArrayList<DeviceData>> facilityDeviceMap = this.getFacilityDeviceMap(facilitID);
        if (facilityDeviceMap == null) {
            facilityDeviceMap = new HashMap<String, ArrayList<DeviceData>>();
            this.deviceMap.put(facilitID, facilityDeviceMap);
        }
        if ((deviceList = (ArrayList<DeviceData>)facilityDeviceMap.get(deviceType)) == null) {
            deviceList = new ArrayList<DeviceData>();
            facilityDeviceMap.put(deviceType, deviceList);
        }
        deviceList.add(deviceData);
    }

    public List getDeviceList(String facilityID, String deviceType) {
        HashMap facilityDeviceMap = this.getFacilityDeviceMap(facilityID);
        if (facilityDeviceMap != null) {
            return this.getDeviceList(facilityDeviceMap, deviceType);
        }
        return null;
    }

    public List getDisk(String facilityID) {
        return this.getDeviceList(facilityID, "disk");
    }

    public List getNic(String facilityID) {
        return this.getDeviceList(facilityID, "nic");
    }

    public List getAll() {
        ArrayList deviceList = new ArrayList();
        Set keys = this.deviceMap.keySet();
        for (String facilitID : keys) {
            HashMap facilityDeviceMap = this.getFacilityDeviceMap(facilitID);
            Collection dl = facilityDeviceMap.values();
            Iterator itrDl = dl.iterator();
            while (itrDl.hasNext()) {
                deviceList.addAll((ArrayList)itrDl.next());
            }
        }
        return deviceList;
    }

    private HashMap getFacilityDeviceMap(String facilityID) {
        return (HashMap)this.deviceMap.get(facilityID);
    }

    private ArrayList getDeviceList(HashMap facilityDeviceMap, String deviceType) {
        return (ArrayList)facilityDeviceMap.get(deviceType);
    }
}

