/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.xml.rpc.server.ServiceLifecycle;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;

public class EJBProvider
extends org.jboss.axis.providers.java.EJBProvider {
    protected Class remoteClass;
    protected Object ejbHome;
    protected Method ejbCreateMethod;

    protected synchronized Object getEJBHome(String jndiName) throws NamingException {
        if (this.ejbHome == null) {
            this.ejbHome = this.getCachedContext().lookup(jndiName);
        }
        return this.ejbHome;
    }

    protected synchronized Method getEJBCreateMethod(String jndiName) throws NamingException, NoSuchMethodException {
        if (this.ejbCreateMethod == null) {
            Object ejbHome = this.getEJBHome(jndiName);
            this.ejbCreateMethod = ejbHome.getClass().getMethod("create", empty_class_array);
        }
        return this.ejbCreateMethod;
    }

    protected Object makeNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        Object ejbHome = this.getEJBHome(clsName);
        Method createMethod = this.getEJBCreateMethod(clsName);
        return new EJBServiceLifeCycle(createMethod.invoke(ejbHome, empty_object_array));
    }

    protected synchronized Class getServiceClass(String beanJndiName, SOAPService service, MessageContext msgContext) throws AxisFault {
        if (this.remoteClass == null) {
            try {
                this.remoteClass = this.getEJBCreateMethod(beanJndiName).getReturnType();
            }
            catch (NamingException e) {
                throw new AxisFault("Could not find home in JNDI", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new AxisFault("Could not find create method at home ;-)", (Throwable)e);
            }
        }
        return this.remoteClass;
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        if (msgContext != null) {
            boolean isSoapAction = msgContext.getProperty("org.jboss.net.axis.server.ACTION_HANDLER_PRESENT") == Boolean.TRUE;
            Iterator alloperations = msgContext.getService().getServiceDescription().getOperations().iterator();
            while (alloperations.hasNext()) {
                OperationDesc opDesc = (OperationDesc)alloperations.next();
                opDesc.setSoapAction(isSoapAction ? msgContext.getService().getName() : null);
            }
        }
        super.generateWSDL(msgContext);
    }

    public void processMessage(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) throws Exception {
        super.processMessage(msgContext, reqEnv, resEnv, ((EJBServiceLifeCycle)obj).serviceObject);
    }

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        ServiceDesc serviceDescription = service.getServiceDescription();
        ArrayList<String> stopClasses = serviceDescription.getStopClasses();
        if (stopClasses == null) {
            stopClasses = new ArrayList<String>();
        }
        stopClasses.add("javax.ejb.EJBObject");
        stopClasses.add("javax.ejb.EJBLocalObject");
        serviceDescription.setStopClasses(stopClasses);
        super.initServiceDesc(service, msgContext);
    }

    protected static class EJBServiceLifeCycle
    implements ServiceLifecycle,
    HttpSessionBindingListener {
        protected Object serviceObject;

        protected EJBServiceLifeCycle(Object serviceObject) {
            this.serviceObject = serviceObject;
        }

        public void destroy() {
            try {
                if (this.serviceObject instanceof EJBObject) {
                    try {
                        ((EJBObject)this.serviceObject).remove();
                    }
                    catch (RemoteException e) {}
                } else {
                    ((EJBLocalObject)this.serviceObject).remove();
                }
            }
            catch (RemoveException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void init(Object arg0) {
        }

        public void valueBound(HttpSessionBindingEvent arg0) {
            this.init(arg0);
        }

        public void valueUnbound(HttpSessionBindingEvent arg0) {
            this.destroy();
        }
    }
}

